<?php

namespace Elementor;
class Foodking_About_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_about_two';
	}
    public function get_title() {
		return esc_html__( 'About Food Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-post-list';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'about_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'section_shape_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Body Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'about_product_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Product Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'left_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Left Column Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'we cook', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'left_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Left Column Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'hot', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'left_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Left Column Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'sandwiches for you', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'about our food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'the best delicious food', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'made from us...', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Its the perfect dining experience where every dish is crafted with fresh, high-quality dining experience Experience quick and efficient service that ensures your food is servead fresh Its the where every dining experience where every dish is crafted with fresh, high-quality ingredients fresh, high-quality', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_shadow_content_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Inner Shadow Content 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'o', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_shadow_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Satsified Clients', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_count_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Count', 'foodking-toolkit' ),
                    'default' => esc_html__( '250', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_counter_sign_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Plus', 'foodking-toolkit' ),
                    'default' => esc_html__( '+', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'inner_shadow_content_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Inner Shadow Content 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'F', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_shadow_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Total food catagories', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_count_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Count 2', 'foodking-toolkit' ),
                    'default' => esc_html__( '153', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'inner_shadow_content_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Inner Shadow Content 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'A', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_shadow_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'awward win', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'inner_count_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Count 3', 'foodking-toolkit' ),
                    'default' => esc_html__( '25', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
        
            $this->add_control(
                'about_info_avatar',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Info Avatar Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'about_info_signature',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Signature Image', 'foodking-toolkit' ),
                ]
            );
            
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title First Part', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Foundation, since', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text_2', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title Middle Part', 'foodking-toolkit' ),
                    'default' => esc_html__( '21st', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text_3', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title Last Part', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Oct , 2019', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'about_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .about-section',
                ]
            );
            $this->add_control(
                'left_title1_color',
                [
                    'label' => esc_html__( 'Left Card Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper-2 .pizza-image .quate-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Left Card Title Typography', 'foodking-toolkit' ),
                    'name' => 'left_title1_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper-2 .pizza-image .quate-content h3',
                ]
            );
            $this->add_control(
                'left_bold_color',
                [
                    'label' => esc_html__( 'Left Card Bold Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper-2 .pizza-image .quate-content h3 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Left Card Bold Title Typography', 'foodking-toolkit' ),
                    'name' => 'left_bold_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper-2 .pizza-image .quate-content h3 span',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper-2 .about-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper-2 .about-content p',
                ]
            );
            $this->add_control(
                'inner_title_color',
                [
                    'label' => esc_html__( 'Inner Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper-2 .about-content .about-counter-area .counter-items h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Inner Title Typography', 'foodking-toolkit' ),
                    'name' => 'inner_title_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper-2 .about-content .about-counter-area .counter-items h5',
                ]
            );
            $this->add_control(
                'inner_content_color',
                [
                    'label' => esc_html__( 'Inner Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper-2 .about-content .about-counter-area .counter-items h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Inner Content Typography', 'foodking-toolkit' ),
                    'name' => 'inner_content_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper-2 .about-content .about-counter-area .counter-items h2',
                ]
            );
            $this->add_control(
                'inner_bg_color',
                [
                    'label' => esc_html__( 'Inner Shadow Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper-2 .about-content .about-counter-area .counter-items h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Inner Shadow Typography', 'foodking-toolkit' ),
                    'name' => 'inner_bg_typography',
                    'selector' => '{{WRAPPER}} .about-wrapper-2 .about-content .about-counter-area .counter-items h3',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn-2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bold_color',
                [
                    'label' => esc_html__( 'Bottom Bold Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .about-wrapper-2 .about-content .about-info .theme-btn-2 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn-2' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn-2:hover::before' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn-2:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn-2',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>

    <!-- About Section Start -->
    <section class="about-section section-padding pt-0">
        <div class="leaves-shape">
            <?php if($settings['section_shape_image']['url']): ?>
                <img src="<?php echo esc_url($settings['section_shape_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif; ?>
        </div>
        <div class="container">
            <div class="about-wrapper-2">
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-5">
                        <?php if($settings['about_product_image']['url']): ?>
                            <div class="pizza-image">
                                <img src="<?php echo esc_url($settings['about_product_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <div class="quate-content">
                                    <h3>
                                    <?php echo esc_html($settings['left_title_1']);?> <span><?php echo esc_html($settings['left_title_2']);?></span> <br>
                                    <?php echo esc_html($settings['left_title_3']);?>
                                    </h3>
                                </div>
                            </div>
                        <?php endif; ?>  
                    </div>
                    <div class="col-xl-7 col-lg-7 mt-5 mt-lg-0">
                        <div class="about-content">
                            <div class="section-title">
                                <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                                <h2 class="wow fadeInUp" data-wow-delay=".3s"> 
                                <?php echo esc_html($settings['title_1']);?> <br>
                                <?php echo esc_html($settings['title_2']);?>
                                </h2>
                            </div>
                            <p class="wow fadeInUp" data-wow-delay=".5s">
                                <?php echo wp_kses_post($settings['content']);?>
                            </p>
                            <div class="about-counter-area d-flex align-items-center justify-content-between">
                                <div class="counter-items wow fadeInUp" data-wow-delay=".3s">
                                    <h3><?php echo esc_html($settings['inner_shadow_content_1']);?></h3>
                                    <h5><?php echo esc_html($settings['inner_shadow_title_1']);?></h5>
                                    <h2><?php echo esc_html($settings['inner_count_1']);?><?php echo esc_html($settings['inner_counter_sign_1']);?></h2>
                                </div>
                                <div class="counter-items wow fadeInUp" data-wow-delay=".5s">
                                    <h3><?php echo esc_html($settings['inner_shadow_content_2']);?></h3>
                                    <h5><?php echo esc_html($settings['inner_shadow_title_2']);?></h5>
                                    <h2><?php echo esc_html($settings['inner_count_2']);?><?php echo esc_html($settings['inner_counter_sign_1']);?></h2>
                                </div>
                                <div class="counter-items wow fadeInUp" data-wow-delay=".7s">
                                    <h3><?php echo esc_html($settings['inner_shadow_content_3']);?></h3>
                                    <h5><?php echo esc_html($settings['inner_shadow_title_3']);?></h5>
                                    <h2><?php echo esc_html($settings['inner_count_3']);?><?php echo esc_html($settings['inner_counter_sign_1']);?></h2>
                                </div>
                            </div> 
                            <div class="about-info">
                                <div class="profile d-flex align-items-center wow fadeInUp" data-wow-delay=".3s">
                                    <div class="profile-img bg-cover" style="background-image: url(<?php echo esc_url($settings['about_info_avatar']['url']);?>);"></div>
                                    <?php if($settings['about_info_signature']['url']): ?>
                                        <img src="<?php echo esc_url($settings['about_info_signature']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif; ?>
                                </div>
                                <?php if($settings['btn_text']): ?>
                                    <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn-2 wow fadeInUp" data-wow-delay=".5s"><?php echo esc_html($settings['btn_text']);?> <span><?php echo esc_html($settings['btn_text_2']);?></span> <?php echo esc_html($settings['btn_text_3']);?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_About_Two_Widget );