<?php

namespace Elementor;
class Foodking_Latest_Blog_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_latest_blog_two';
	}
    public function get_title() {
		return esc_html__( 'Latest Blog Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-posts-grid';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    public function get_keywords() {
		return [ 'post', 'blog' ];
	}
    protected function register_controls() {
        // Elementor Featured Blog Section Control
		$this->start_controls_section(
			'latest_blog_tab',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'top_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'NEWS & BLOG', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Explore news & blog', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'limit',
                [
                    'label' => esc_attr__( 'Blogs Limit', 'foodking-toolkit' ),
                    'description' => esc_attr__( 'Choose posts limit', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => '3',

                ]
            );
            $this->add_control(
                'posts',
                [
                    'label' => esc_attr__( 'Show Only Specific Blogs', 'foodking-toolkit' ),
                    'description' => esc_attr__( 'Enter post IDs with comma, like: 1,2,3,4,5', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,

                ]
            );
            $this->add_control(
                'categories',
                [
                    'label' => esc_attr__( 'Show Only Specific Categories', 'foodking-toolkit' ),
                    'description' => esc_attr__( 'Enter categories slugs to narrow output (Note: only listed categories will be displayed, divide categories with line break (Enter)).', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,

                ]
            );
            $this->add_control(
                'tags',
                [
                    'label' => esc_attr__( 'Show Only Specific Tags', 'foodking-toolkit' ),
                    'description' => esc_attr__( 'Enter tags slugs to narrow output (Note: only listed tags will be displayed, divide categories with line break (Enter)).', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,

                ]
            );
            $this->add_control(
                'order_by',
                [
                    'label' => esc_attr__( 'Order By', 'foodking-toolkit' ),
                    'description' => esc_attr__( '', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'date' => esc_attr__( 'Date', 'foodking-toolkit' ),
                        'name' => esc_attr__( 'Name', 'foodking-toolkit' ),
                        'author' => esc_attr__( 'Author', 'foodking-toolkit' ),
                        'rand' => esc_attr__( 'Random', 'foodking-toolkit' ),
                        'comment_count' => esc_attr__( 'Comment Count', 'foodking-toolkit' ),
                    ],
                    'default' => 'date',

                ]
            );
            $this->add_control(
                'order',
                [
                    'label' => esc_attr__( 'Order', 'foodking-toolkit' ),
                    'description' => esc_attr__( '', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'desc' => esc_attr__( 'Descending', 'foodking-toolkit' ),
                        'asc' => esc_attr__( 'Ascending', 'foodking-toolkit' ),
                    ],
                    'default' => 'desc',

                ]
            );

            $this->add_control(
                'shape_img_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_img_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 2', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();

        // Elementor Style Control
        $this->start_controls_section(
			'latest_blog_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .news-section',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'cat_text_color',
                [
                    'label' => esc_html__( 'Category Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-news-items.style-2 .news-content .post-date li' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Category Typography', 'foodking-toolkit' ),
                    'name' => 'cat_typography',
                    'selector' => '{{WRAPPER}} .single-news-items.style-2 .news-content .post-date li',
                ]
            );
            $this->add_control(
                'date_color',
                [
                    'label' => esc_html__( 'Date Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-news-items.style-2 .news-content .post-date li span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Date Typography', 'foodking-toolkit' ),
                    'name' => 'date_typography',
                    'selector' => '{{WRAPPER}} .single-news-items.style-2 .news-content .post-date li span',
                ]
            );
            $this->add_control(
                'blog_title_color',
                [
                    'label' => esc_html__( 'Blog Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-news-items.style-2 .news-content h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'blog_title_hover_color',
                [
                    'label' => esc_html__( 'Blog Title Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-news-items.style-2 .news-content h3 a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Blog Title Typography', 'foodking-toolkit' ),
                    'name' => 'blog_title_typography',
                    'selector' => '{{WRAPPER}} .single-news-items.style-2 .news-content h3 a',
                ]
            );
            $this->add_control(
                'readmore_color',
                [
                    'label' => esc_html__( 'Read More Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .link-btn.style-2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'readmore_hover_color',
                [
                    'label' => esc_html__( 'Read More Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .link-btn.style-2:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_color',
                [
                    'label' => esc_html__( 'Button Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .link-btn.style-2 i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_hover_color',
                [
                    'label' => esc_html__( 'Button Icon Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .link-btn.style-2:hover i' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();$limit = ( isset( $settings['limit'] ) && is_numeric($settings['limit']) ) ? intval( $settings['limit'] ) : 3;
        $tags_query = !is_array( $settings['tags'] ) ? $settings['tags'] : '';
        $categories_query = ( isset($settings['categories']) && $settings['categories'] ) ? str_replace("post:","", $settings['categories'] ) : array();
        $orderby = ( isset($settings['order_by']) && $settings['order_by'] ) ? esc_attr( $settings['order_by'] ) : 'post_date';
        $order = ( isset($settings['order']) && $settings['order'] ) ? esc_attr( $settings['order'] ) : 'desc';

        /* Limit Blogs */
        if( isset( $settings['posts'] ) && $settings['posts'] ) :
            $post_array = explode(',', $settings['posts']); $i=0;
            foreach( $post_array as $specific_post ) {
                $post_array[$i] = intval( $specific_post );
                $i++;
            }
        else :
            $post_array = array();
        endif;

        if( count( $post_array ) > 0 ) :
            $posts = new \WP_Query( array(
                'post_type' => 'post',
                'posts_per_page' => $limit,
                'post__in' => $post_array,
                'orderby' => 'post__in'
            ));
        else :
            $posts = new \WP_Query( array(
                'post_type' => 'post',
                'posts_per_page' => $limit,
                'category_name' => $categories_query,
                'orderby' => $orderby,
                'order' => $order,
                'tag' => $tags_query,
            ));
        endif;
        ?>
        
        <!-- News Section Start -->
        <section class="news-section fix section-padding">
            <div class="container">
                <div class="section-title text-center">
                    <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                    <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['title']);?></h2>
                </div>
                <div class="row">
                <?php
                    while ($posts->have_posts()): $posts->the_post();
                        ?>
                        <div class="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                            <?php if (has_post_thumbnail()): ?>
                                <div class="single-news-items style-2">
                                    <div class="news-image bg-cover" style="background-image: url(<?php the_post_thumbnail_url(); ?>);"></div>
                                    <div class="news-content">
                                        <ul class="post-date d-flex align-items-center justify-content-between">
                                        <?php
                                            // Get the categories for the current post
                                            $categories = get_the_category();
                                            
                                            // Check if categories are available
                                            if ($categories) {
                                                // Assuming you want to use the first category
                                                $category = $categories[0];
                                                $category_link = get_category_link($category->term_id);
                                                ?>
                                                <li><?php echo esc_html($category->name); ?></li>
                                                <?php
                                            } else {
                                                // Category not found, you can provide a fallback or error message here
                                                echo 'Category not found.';
                                            }
                                            ?>
                                            <li><span><?php echo esc_html(get_the_date('d M Y')); ?></span></li>
                                        </ul>
                                        <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                                        <a href="<?php the_permalink();?>" class="link-btn style-2">
                                        <?php esc_html_e('Read More', 'foodking-toolkit'); ?> <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                </div>
            </div>
        </section>
        <?php
    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Latest_Blog_Two_Widget );