<?php

namespace Elementor;
class Foodking_Brand_Logo_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_brand_logo';
	}
    public function get_title() {
		return esc_html__( 'Brand Logo', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-carousel';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'brand_logo_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'GLOBAL', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( '5K+', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'HAPPY SPONSORS WITH US', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'brand_logo_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Brand Logo Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'brand_logo_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .brand-title h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_middle_color',
                [
                    'label' => esc_html__( 'Middle Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .brand-wrapper .brand-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .brand-title h4',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Brand Section Start -->
    <section class="brand-shape section-padding fix section-bg pt-0">
        <div class="container">
            <div class="brand-wrapper">
                <div class="brand-title">
                    <h4>
                        <?php echo esc_html($settings['title_1']);?> <span><?php echo esc_html($settings['title_2']);?></span> <?php echo esc_html($settings['title_3']);?>
                    </h4>
                </div>
                <div class="swiper brand-slider">
                    <div class="swiper-wrapper">
                        <?php foreach ($settings['lists'] as $item):?>
                            <div class="swiper-slide">
                                <div class="brand-image">
                                    <?php if($item['brand_logo_image']['url']):?>
                                        <img src="<?php echo esc_url($item['brand_logo_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                    <?php endif;?>
                                </div>
                            </div>
                        <?php endforeach;?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Brand_Logo_Widget );