<?php

namespace Elementor;
class Foodking_Contact_Info_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_contact_info';
	}
    public function get_title() {
		return esc_html__( 'اطلاعات تماس', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-review';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'contact_info_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'info_icon_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Info Icon Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'address line', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'content_1',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content Line 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Bowery St, New York, 37 USA', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'content_2',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content Line 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'NY 10013,USA', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'contact_info_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            
            $this->add_control(
                'bg_color',
                [
                    'label' => esc_html__( 'Card Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-info-items' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'bg_hover_color',
                [
                    'label' => esc_html__( 'Card Hover Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-info-items:hover, .contact-info-items.active' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card_active_color',
                [
                    'label' => esc_html__( 'Active Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-info-items:hover .content h3, .contact-info-items:hover .content p, .contact-info-items.active .content h3, .contact-info-items.active .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .contact-info-items .content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .contact-info-items .content h3',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .content p',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!--<< Contact Info Section Start >>-->
    <section class="contact-info-section fix section-padding section-bg">
        <div class="container">
            <div class="row g-4">
                <?php foreach($settings['lists'] as $item):?>
                    <div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                        <div class="contact-info-items text-center">
                            <div class="icon">
                                <?php if($item['info_icon_image']['url']): ?>
                                    <img src="<?php echo esc_url($item['info_icon_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="content">
                                <h3><?php echo esc_html($item['title']);?></h3>
                                <p>
                                <?php echo wp_kses_post($item['content_1']);?> <br>
                                <?php echo wp_kses_post($item['content_2']);?>
                                </p>
                            </div>
                        </div>
                    </div>
                <?php endforeach;?>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Contact_Info_Widget );