<?php

namespace Elementor;
class Foodking_CTA_Banner_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_cta_one';
	}
    public function get_title() {
		return esc_html__( 'CTA Banner One', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-call-to-action';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'banner_one_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'banner_one_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'banner_shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Shape Image 3', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CRISPY, EVERY BITE TASTE', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( '30 MINUTES FAST', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'DELIVERY', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CHALLAGE', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'banner_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .main-cta-banner::before',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>
        
    <!-- Main Cta Banner Section Start -->
    <?php if($settings['banner_one_bg_image']['url']):?>
        <section class="main-cta-banner section-padding pt-0">
            <div class="container">
                <div class="main-cta-banner-wrapper bg-cover mt-10" style="background-image: url(<?php echo esc_url($settings['banner_one_bg_image']['url']);?>);">
                    <div class="section-title">
                        <span class="theme-color-3 wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                        <h2 class="text-white wow fadeInUp" data-wow-delay=".3s">
                            <?php echo esc_html($settings['title_1']);?> <br>
                            <span class="theme-color-3"><?php echo esc_html($settings['title_2']);?></span> <?php echo esc_html($settings['title_3']);?>
                        </h2>
                    </div>
                    <?php if($settings['btn_text']): ?>
                        <a <?php echo $this->get_render_attribute_string('btn_link'); ?> class="theme-btn bg-white mt-4 mt-md-0 wow fadeInUp" data-wow-delay=".5s">
                            <span class="button-content-wrapper d-flex align-items-center">
                                <span class="button-icon">
                                    <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                    <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                    <?php else: ?>
                                        <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                    <?php endif; ?>
                                </span>
                                <span class="button-text"><?php echo esc_html($settings['btn_text']);?></span>
                            </span>
                        </a>
                    <?php endif;?>
                    <div class="arrow-shape">
                        <?php if($settings['banner_shape_image_1']['url']):?>
                            <img src="<?php echo esc_url($settings['banner_shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                        <?php endif;?>
                    </div>
                    <div class="delivery-man">
                        <?php if($settings['banner_shape_image_2']['url']):?>
                            <img src="<?php echo esc_url($settings['banner_shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                        <?php endif;?>
                    </div>
                    <div class="frame-shape">
                        <?php if($settings['banner_shape_image_3']['url']):?>
                            <img src="<?php echo esc_url($settings['banner_shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                        <?php endif;?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif;?>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_CTA_Banner_One_Widget );