<?php

namespace Elementor;
class Foodking_FAQ_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_faq';
	}
    public function get_title() {
		return esc_html__( 'FAQ', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-accordion';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'faq_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'frequently ask question', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'top_content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Top Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Frequently ask question', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'ARE YOUR MENU PRICES THE SAME AS THOSE AT THE RESTAURANT?', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'faq_active', [
					'label' => esc_html__( 'Item', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Active', 'foodking-toolkit' ),
                    'label_off' => esc_html__( 'Default', 'foodking-toolkit' ),
                    'return_value' => 'yes',
                ]
            );
            $repeater->add_control(
                'content',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look even slightly believable.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'faq_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .faq-section',
                ]
            );
            $this->add_control(
                't_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 't_title_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                't_c_color',
                [
                    'label' => esc_html__( 'Top Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Content Typography', 'foodking-toolkit' ),
                    'name' => 't_c_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .faq-content .accordion-item .accordion-header .accordion-button',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .faq-content .accordion-item .accordion-collapse .accordion-body' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .faq-content .accordion-item .accordion-collapse .accordion-body',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        <!-- Faq Section Start -->
        <section class="faq-section fix section-padding">
            <div class="container">
                <div class="section-title text-center">
                    <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                    <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo wp_kses_post($settings['top_content']);?></h2>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="faq-content">
                            <div class="faq-accordion">
                                <div class="accordion" id="accordion">
                                    <?php 
                                    $total_items = count($settings['lists']);
                                    $i = 1; 
                                    foreach($settings['lists'] as $item):
                                        $is_first_item = ($i === 1);
                                        $is_last_item = ($i === $total_items);
                                        $collapse_class = $is_first_item ? 'show' : '';
                                        ?>
                                        <div class="accordion-item">
                                            <h4 class="accordion-header">
                                                <button class="accordion-button <?php echo $collapse_class; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#faq<?php echo esc_html($i); ?>" aria-expanded="<?php echo $is_first_item ? 'true' : 'false'; ?>" aria-controls="faq<?php echo esc_html($i); ?>">
                                                    <?php echo esc_html($item['title']);?>
                                                </button>
                                            </h4>
                                            <div id="faq<?php echo esc_html($i); ?>" class="accordion-collapse collapse <?php echo $collapse_class; ?>" data-bs-parent="#accordion">
                                                <div class="accordion-body">
                                                    <?php echo wp_kses_post($item['content']);?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php 
                                    $i++;
                                    endforeach;
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_FAQ_Widget );