<?php

namespace Elementor;
class Foodking_Food_Banner_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_food_banner_one';
	}
    public function get_title() {
		return esc_html__( 'Food Banner One', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-posts-justified';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'food_banner_one_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'food_banner_one_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Background Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'food_banner_one_offer_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Offer Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'food_banner_one_text_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Text Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'food_banner_one_mainfood_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Main Food Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CRISPY, EVERY BITE TASTE', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'SUPER', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'DELICIOUS', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
            $this->add_control(
                'shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 2', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'food_banner_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items .offer-content h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items .offer-content h5',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .single-offer-items .offer-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .single-offer-items .offer-content h3',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Food Banner Section Start -->
    <section class="food-banner-section section-padding fix section-bg pt-0">
        <div class="chili-shape">
            <?php if($settings['shape_image_1']['url']):?>
                <img src="<?php echo esc_url($settings['shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif; ?>
        </div>
        <div class="fry-shape">
            <?php if($settings['shape_image_2']['url']):?>
                <img src="<?php echo esc_url($settings['shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif; ?>
        </div>
        <div class="container">
            <div class="row">
                <?php
                $i = 1;
                foreach ($settings['lists'] as $item):?>
                    <?php if($i == 1): ?>
                    <div class="col-xl-5">
                    <?php elseif($i == 2): ?>
                    <div class="col-xl-7">
                    <?php elseif($i == 3): ?>
                    <div class="col-xl-5">
                    <?php else: ?>
                    <div class="col-xl-6">
                        <?php endif; ?>
                        <?php if ($item['food_banner_one_bg_image']['url']): ?>
                            <div class="wow fadeInUp" data-wow-delay=".3s">
                                <div class="single-offer-items custom-single-offer-items bg-cover" style="background-image: url(<?php echo esc_url($item['food_banner_one_bg_image']['url']); ?>);">
                                    <div class="offer-content">
                                        <?php if ($item['top_title']): ?>
                                            <h5><?php echo esc_html($item['top_title']); ?></h5>
                                        <?php endif; ?>
                                        <?php if ($item['title_1']): ?>
                                        <h3>
                                            <?php echo esc_html($item['title_1']); ?> <br>
                                            <?php echo esc_html($item['title_2']); ?>
                                        </h3>
                                        <?php endif; ?>
                                    </div>
                                    <div class="offer-image">
                                        <?php if ($item['food_banner_one_offer_image']['url']): ?>
                                            <img src="<?php echo esc_url($item['food_banner_one_offer_image']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div class="burger-text">
                                        <?php if ($item['food_banner_one_text_image']['url']): ?>
                                            <img src="<?php echo esc_url($item['food_banner_one_text_image']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div class="main-food">
                                        <?php if ($item['food_banner_one_mainfood_image']['url']): ?>
                                            <img src="<?php echo esc_url($item['food_banner_one_mainfood_image']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php $i++;
                endforeach; ?>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Banner_One_Widget );