<?php

namespace Elementor;
class Foodking_Food_Banner_Six_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_food_banner_six';
	}
    public function get_title() {
		return esc_html__( 'Food Banner Six', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-posts-justified';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'food_banner_six_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'card_1_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_vector_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-1 Vector Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_1_price',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Price', 'foodking-toolkit' ),
                    'default' => esc_html__( '$38', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_1_top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'start price $25', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_1_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Bold Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'delicious', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_1_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Bold Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'hamburger', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_1_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-1 Bold Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'fries', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_1_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_1_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
            
            $this->add_control(
                'card_2_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_2_vector_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-2 Vector Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_2_price',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Price', 'foodking-toolkit' ),
                    'default' => esc_html__( '$43', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'start price $25', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Bold Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Super', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Bold Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CHICKEN', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-2 Bold Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'fry', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_2_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type_2',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el_2',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type_2' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon_2',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type_2' => 'theme',
                    ]
                ]
            );

            $this->add_control(
                'card_3_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_3_vector_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card-3 Vector Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'card_3_price',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Price', 'foodking-toolkit' ),
                    'default' => esc_html__( '$38', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'start price $25', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Bold Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'delicious', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Bold Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'hamburger', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Card-3 Bold Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'fries', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'card_3_btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_icon_type_3',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el_3',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type_3' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon_3',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type_3' => 'theme',
                    ]
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'food_banner_six_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .fix',
                ]
            );
            $this->add_control(
                'card1',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-banner-items-2 .food-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'card1_typography',
                    'selector' => '{{WRAPPER}} .food-banner-items-2 .food-content h4',
                ]
            );
            $this->add_control(
                'card2',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .text-white' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'card2_typography',
                    'selector' => '{{WRAPPER}} .text-white',
                ]
            );
            $this->add_control(
                'card3',
                [
                    'label' => esc_html__( 'Card 1 & 3 Price Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-banner-items-2 .price span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 1 & 3 Price Typography', 'foodking-toolkit' ),
                    'name' => 'card3_typography',
                    'selector' => '{{WRAPPER}} .food-banner-items-2 .price span',
                ]
            );
            $this->add_control(
                'card4',
                [
                    'label' => esc_html__( 'Card 2 Price Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-banner-items-2 .price.style-2 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card 2 Price Typography', 'foodking-toolkit' ),
                    'name' => 'card4_typography',
                    'selector' => '{{WRAPPER}} .food-banner-items-2 .price.style-2 span',
                ]
            );
            $this->add_control(
                'card5',
                [
                    'label' => esc_html__( 'Button 1 & 3 Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-red' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card13',
                [
                    'label' => esc_html__( 'Button 1 & 3 Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card6',
                [
                    'label' => esc_html__( 'Button 1 & 3 Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-red' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card7',
                [
                    'label' => esc_html__( 'Button 1 & 3 Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-red:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card8',
                [
                    'label' => esc_html__( 'Button 1 & 3 Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-red:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card9',
                [
                    'label' => esc_html__( 'Button 2 Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card14',
                [
                    'label' => esc_html__( 'Button 2 Icon Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card10',
                [
                    'label' => esc_html__( 'Button 2 Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card11',
                [
                    'label' => esc_html__( 'Button 2 Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'card12',
                [
                    'label' => esc_html__( 'Button 2 Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn.bg-yellow:hover::before' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL 1
        if ( ! empty( $settings['card_1_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'card_1_btn_link', $settings['card_1_btn_link'] );
        }
        // Button URL 2
        if ( ! empty( $settings['card_2_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'card_2_btn_link', $settings['card_2_btn_link'] );
        }
        // Button URL 3
        if ( ! empty( $settings['card_3_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'card_3_btn_link', $settings['card_3_btn_link'] );
        }
        ?>
    <!-- Food Banner Section Start -->
    <section class="food-banner fix">
        <div class="row g-3">
            <?php if ($settings['card_1_bg_image']['url']): ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="food-banner-items-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_1_bg_image']['url']); ?>);">
                        <?php if ($settings['card_1_vector_img']['url']): ?>
                            <div class="price bg-cover" style="background-image: url(<?php echo esc_url($settings['card_1_vector_img']['url']); ?>);">
                                <span><?php echo esc_html($settings['card_1_price']); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="food-content">
                            <h4><?php echo esc_html($settings['card_1_top_title']); ?></h4>
                            <h2 class="text-white">
                            <?php echo esc_html($settings['card_1_title_1']); ?> <br>        
                            <?php echo esc_html($settings['card_1_title_2']); ?> <br>
                            <?php echo esc_html($settings['card_1_title_3']); ?>
                            </h2>
                            <?php if($settings['card_1_btn_text']): ?>
                                <a <?php echo $this->get_render_attribute_string('card_1_btn_link'); ?> class="theme-btn bg-red mt-4">
                                    <span class="button-content-wrapper d-flex align-items-center">
                                        <span class="button-icon">
                                            <?php if($settings['btn_icon_type'] == 'theme'): ?>
                                            <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                                            <?php else: ?>
                                            <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                            <?php endif; ?>
                                        </span>
                                        <span class="button-text"><?php echo esc_html($settings['card_1_btn_text']); ?></span>
                                    </span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($settings['card_2_bg_image']['url']): ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="food-banner-items-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_2_bg_image']['url']); ?>);">
                        <?php if ($settings['card_2_vector_img']['url']): ?>
                            <div class="price style-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_2_vector_img']['url']); ?>);">
                                <span><?php echo esc_html($settings['card_2_price']); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="food-content">
                            <h4><?php echo esc_html($settings['card_2_top_title']); ?></h4>
                            <h2 class="text-white">
                            <?php echo esc_html($settings['card_2_title_1']); ?> <br>        
                            <?php echo esc_html($settings['card_2_title_2']); ?> <br>
                            <?php echo esc_html($settings['card_2_title_3']); ?>
                            </h2>
                            <?php if($settings['card_2_btn_text']): ?>
                                <a <?php echo $this->get_render_attribute_string('card_2_btn_link'); ?> class="theme-btn bg-yellow border-radius-none mt-4">
                                    <span class="button-content-wrapper d-flex align-items-center">
                                        <span class="button-icon">
                                            <?php if($settings['btn_icon_type_2'] == 'theme'): ?>
                                            <i class="<?php echo esc_attr($settings['btn_icon_2']); ?>"></i>
                                            <?php else: ?>
                                            <?php Icons_Manager::render_icon( $settings['btn_icon_el_2'], [ 'aria-hidden' => 'true' ] ); ?>
                                            <?php endif; ?>
                                        </span>
                                        <span class="button-text"><?php echo esc_html($settings['card_2_btn_text']); ?></span>
                                    </span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if ($settings['card_3_bg_image']['url']): ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <div class="food-banner-items-2 bg-cover" style="background-image: url(<?php echo esc_url($settings['card_3_bg_image']['url']); ?>);">
                        <?php if ($settings['card_3_vector_img']['url']): ?>
                            <div class="price bg-cover" style="background-image: url(<?php echo esc_url($settings['card_3_vector_img']['url']); ?>);">
                                <span><?php echo esc_html($settings['card_3_price']); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="food-content">
                            <h4><?php echo esc_html($settings['card_3_top_title']); ?></h4>
                            <h2 class="text-white">
                            <?php echo esc_html($settings['card_3_title_1']); ?> <br>        
                            <?php echo esc_html($settings['card_3_title_2']); ?> <br>
                            <?php echo esc_html($settings['card_3_title_3']); ?>
                            </h2>
                            <?php if($settings['card_3_btn_text']): ?>
                                <a <?php echo $this->get_render_attribute_string('card_3_btn_link'); ?> class="theme-btn bg-red mt-4">
                                    <span class="button-content-wrapper d-flex align-items-center">
                                        <span class="button-icon">
                                            <?php if($settings['btn_icon_type_3'] == 'theme'): ?>
                                            <i class="<?php echo esc_attr($settings['btn_icon_3']); ?>"></i>
                                            <?php else: ?>
                                            <?php Icons_Manager::render_icon( $settings['btn_icon_el_3'], [ 'aria-hidden' => 'true' ] ); ?>
                                            <?php endif; ?>
                                        </span>
                                        <span class="button-text"><?php echo esc_html($settings['card_3_btn_text']); ?></span>
                                    </span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Banner_Six_Widget );