<?php

namespace Elementor;
class Foodking_Food_Comboo_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_grid_banner_one';
	}
    public function get_title() {
		return esc_html__( 'Food Comboo One', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-column';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'grid_banner_one_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'left_bg_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Left Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'left_shape_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Banner Left Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CRISPY, EVERY BITE TASTE', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'trending Food combo offer less', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( '20%', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'subtitle',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Banner Subtitle', 'foodking-toolkit' ),
                    'default' => esc_html__( 'A team of dreamers and doers building unique interactive music and art festivals.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            
            $this->add_control(
                'list_logo_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-1 Logo Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'List-1 Title', 'foodking-toolkit' ),
                    'default' => esc_html__( '30% off 4pcs hot crispy & 8 pcs wing', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'list_bg_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-1 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_product_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-1 Product Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_1_shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-1 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_1_shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-1 Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_1_shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-1 Shape Image 3', 'foodking-toolkit' ),
                ]
            );

            $this->add_control(
                'list_logo_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-2 Logo Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'List-2 Title', 'foodking-toolkit' ),
                    'default' => esc_html__( '20% off tasty pizza with drink', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'list_bg_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-2 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_product_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-2 Product Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_2_shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-2 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_2_shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-2 Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_2_shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-2 Shape Image 3', 'foodking-toolkit' ),
                ]
            );

            $this->add_control(
                'list_logo_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-3 Logo Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'List-3 Title', 'foodking-toolkit' ),
                    'default' => esc_html__( '2pcs humbergur with drinks & sauce', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'list_bg_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-3 Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_product_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-3 Product Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_3_shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-3 Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_3_shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-3 Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'list_3_shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'List-3 Shape Image 3', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'grid_banner_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .food-comboo-section',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'title_middle_color',
                [
                    'label' => esc_html__( 'Title Last Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'subtitle_color',
                [
                    'label' => esc_html__( 'Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-comboo-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'subtitle_typography',
                    'selector' => '{{WRAPPER}} .food-comboo-content p',
                ]
            );
            $this->add_control(
                'list_bg_color',
                [
                    'label' => esc_html__( 'List Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .comboo-wrapper .food-comboo-content .nav .nav-link .food-comboo-list' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'list_active_bg_color',
                [
                    'label' => esc_html__( 'List Active Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .comboo-wrapper .food-comboo-content .nav .nav-link.active .food-comboo-list' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'list_text_color',
                [
                    'label' => esc_html__( 'List Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .comboo-wrapper .food-comboo-content .nav .nav-link .food-comboo-list .comboo-title' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'List Text Typography', 'foodking-toolkit' ),
                    'name' => 'list_text_typography',
                    'selector' => '{{WRAPPER}} .comboo-wrapper .food-comboo-content .nav .nav-link .food-comboo-list .comboo-title',
                ]
            );
            
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Food Comboo Section Start -->
    <?php if($settings['left_bg_image']['url']):?>
        <section class="food-comboo-section fix bg-cover section-padding" style="background-image: url(<?php echo esc_url($settings['left_bg_image']['url']);?>);">
            <div class="drinks-shape">
                <?php if($settings['left_shape_image']['url']):?>
                    <img src="<?php echo esc_url($settings['left_shape_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                <?php endif;?>
            </div>
            <div class="container">
                <div class="comboo-wrapper">
                    <div class="row align-items-center">
                        <div class="col-xl-6">
                            <div class="food-comboo-content">
                                <div class="section-title">
                                    <span class="wow fadeInUp"><?php echo esc_html($settings['top_title']);?></span>
                                    <h2 class="wow fadeInUp" data-wow-delay=".3s">
                                    <?php echo esc_html($settings['title_1']);?> <span><?php echo esc_html($settings['title_2']);?></span>
                                    </h2>
                                </div>
                                <p class="wow fadeInUp" data-wow-delay=".5s">
                                    <?php echo esc_html($settings['subtitle']);?>
                                </p>
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    <button class="nav-link wow fadeInUp" data-wow-delay=".3s" id="nav-home-tab" data-bs-toggle="tab" data-bs-target="#nav-home" type="button" role="tab" aria-controls="nav-home" aria-selected="true">
                                    <span class="food-comboo-list">
                                    <span class="offer-image">
                                    <?php if($settings['list_logo_image_1']['url']):?>
                                        <img src="<?php echo esc_url($settings['list_logo_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif;?>
                                    </span>
                                    <span class="comboo-title">
                                    <?php echo esc_html($settings['list_title_1']);?>
                                    </span>
                                    </span>
                                    </button>
                                    
                                    <button class="nav-link active wow fadeInUp" data-wow-delay=".5s" id="nav-profile-tab" data-bs-toggle="tab" data-bs-target="#nav-profile" type="button" role="tab" aria-controls="nav-profile" aria-selected="false">
                                    <span class="food-comboo-list">
                                    <span class="offer-image">
                                    <?php if($settings['list_logo_image_2']['url']):?>
                                        <img src="<?php echo esc_url($settings['list_logo_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif;?>
                                    </span>
                                    <span class="comboo-title">
                                    <?php echo esc_html($settings['list_title_2']);?>
                                    </span>
                                    </span>
                                    </button>
                                    
                                    <button class="nav-link wow fadeInUp" data-wow-delay=".7s" id="nav-contact-tab" data-bs-toggle="tab" data-bs-target="#nav-contact" type="button" role="tab" aria-controls="nav-contact" aria-selected="false">
                                    <span class="food-comboo-list">
                                    <span class="offer-image">
                                    <?php if($settings['list_logo_image_3']['url']):?>
                                        <img src="<?php echo esc_url($settings['list_logo_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php endif;?>
                                    </span>
                                    <span class="comboo-title">
                                    <?php echo esc_html($settings['list_title_3']);?>
                                    </span>
                                    </span>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-6">
                            <div class="tab-content" id="nav-tab-Content">
                                <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                                    <div class="comboo-image bg-cover" style="background-image: url(<?php echo esc_url($settings['list_bg_image_1']['url']);?>);">
                                        <div class="pizza-text">
                                            <?php if($settings['list_1_shape_image_1']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_1_shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="pizza-image">
                                            <?php if($settings['list_product_image_1']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_product_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="offer-shape">
                                            <?php if($settings['list_1_shape_image_2']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_1_shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="vegetable-shape">
                                            <?php if($settings['list_1_shape_image_3']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_1_shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                                    <div class="comboo-image bg-cover" style="background-image: url(<?php echo esc_url($settings['list_bg_image_2']['url']);?>);">
                                        <div class="pizza-text">
                                            <?php if($settings['list_2_shape_image_1']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_2_shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="pizza-image">
                                            <?php if($settings['list_product_image_2']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_product_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="offer-shape">
                                            <?php if($settings['list_2_shape_image_2']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_2_shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="vegetable-shape">
                                            <?php if($settings['list_2_shape_image_3']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_2_shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">
                                    <div class="comboo-image bg-cover" style="background-image: url(<?php echo esc_url($settings['list_bg_image_3']['url']);?>);">
                                        <div class="pizza-text">
                                            <?php if($settings['list_3_shape_image_1']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_3_shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="pizza-image">
                                            <?php if($settings['list_product_image_3']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_product_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="offer-shape">
                                            <?php if($settings['list_3_shape_image_2']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_3_shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                        <div class="vegetable-shape">
                                            <?php if($settings['list_3_shape_image_3']['url']):?>
                                                <img src="<?php echo esc_url($settings['list_3_shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                            <?php endif;?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif;?>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Comboo_One_Widget );