<?php

namespace Elementor;
class Foodking_Food_Processing_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_food_processing';
	}
    public function get_title() {
		return esc_html__( 'پردازش مواد غذایی', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-plug';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'food_processing_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'top_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'FOOD PROCESSING', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'title', [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'HOW WE SERVE YOU?', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'card__image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Card Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'card__number', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Card Number', 'foodking-toolkit' ),
                    'default' => esc_html__( '01', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'card__title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Card Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'cooking with care', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'card_active', [
					'label' => esc_html__( 'Card Active', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Active', 'foodking-toolkit' ),
                    'label_off' => esc_html__( 'Default', 'foodking-toolkit' ),
                    'return_value' => 'yes',
                ]
            );
            $repeater->add_control(
                'card__content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Card Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Its the perfect dining experience where Experience quick and efficient', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'food_processing_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .fix',
                ]
            );
            $this->add_control(
                'card1',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'card1_typography',
                    'selector' => '{{WRAPPER}} .section-title span',
                ]
            );
            $this->add_control(
                'card2',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'card2_typography',
                    'selector' => '{{WRAPPER}} .section-title h2',
                ]
            );
            $this->add_control(
                'card3',
                [
                    'label' => esc_html__( 'Card Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-processing-wrapper .food-processing-items .food-processing-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card Title Typography', 'foodking-toolkit' ),
                    'name' => 'card3_typography',
                    'selector' => '{{WRAPPER}} .food-processing-wrapper .food-processing-items .food-processing-content h3',
                ]
            );
            $this->add_control(
                'card4',
                [
                    'label' => esc_html__( 'Card Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .food-processing-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Card Content Typography', 'foodking-toolkit' ),
                    'name' => 'card4_typography',
                    'selector' => '{{WRAPPER}} .food-processing-content p',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();

        ?>
    <!-- Food Processing Section Start -->
    <section class="food-processing-section section-padding pt-0 fix section-bg">
        <div class="container">
            <div class="section-title text-center">
                <span class="wow fadeInUp"><?php echo $settings['top_title']; ?></span>
                <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo $settings['title']; ?></h2>
            </div>
            <div class="food-processing-wrapper">
                <div class="row">
                    <?php $i= 1; foreach($settings['lists'] as $item): ?>
                        <?php if($item['card_active'] != 'yes'): ?>
                            <div class="col-xl-4 col-md-6 wow fadeInUp" data-wow-delay=".3s">
                                <div class="food-processing-items border-style center">
                                    <div class="food-processing-image">
                                        <?php if ($item['card__image']['url']): ?>
                                            <img src="<?php echo esc_url($item['card__image']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                        <div class="number">
                                            <span><?php echo $item['card__number']; ?></span>
                                        </div>
                                    </div>
                                    <div class="food-processing-content">
                                        <h3><?php echo $item['card__title']; ?></h3>
                                        <p><?php echo wp_kses_post($item['card__content']); ?></p>
                                    </div>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="col-xl-4 col-md-6 wow fadeInUp" data-wow-delay=".5s">
                                <div class="food-processing-items center active">
                                    <div class="food-processing-image">
                                        <?php if ($item['card__image']['url']): ?>
                                            <img src="<?php echo esc_url($item['card__image']['url']); ?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme', 'foodking-toolkit'); ?>">
                                        <?php endif; ?>
                                        <div class="number">
                                            <span><?php echo $item['card__number']; ?></span>
                                        </div>
                                    </div>
                                    <div class="food-processing-content">
                                        <h3><?php echo $item['card__title']; ?></h3>
                                        <p><?php echo wp_kses_post($item['card__content']); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php $i++; endforeach; ?>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Food_Processing_Widget );