<?php

namespace Elementor;
class Foodking_Footer_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_footer';
	}
    public function get_title() {
		return esc_html__( 'Footer Widget', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-footer';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'footer_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Footer Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Footer Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'footer_logo',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Upload Footer Logo', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'logo_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Logo URL', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'short_desc_1',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Short Description Part 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'We believe it has the power to do', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'short_desc_2',
                [
                    'type' =>Controls_Manager::TEXTAREA,
                    'label' => esc_html__( 'Short Description Part 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'amazing things.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'sub_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Sub Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Interested in working with us?', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'email_address',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Email Address', 'foodking-toolkit' ),
                    'default' => esc_html__( 'info@example.com', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'email_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Email URL', 'foodking-toolkit' ),
                ]
            );

            $this->add_control(
                'quick_links_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Quick Links Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Quick Links', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'my_accounts_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'My Account Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'My Account', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'address_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Address Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Address:', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'address_text_1', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Address Top Text', 'foodking-toolkit' ),
                    'default' => esc_html__( '570 8th Ave, New York,NY', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'address_text_2', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Address Color Text', 'foodking-toolkit' ),
                    'default' => esc_html__( '10018', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'address_text_3', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Address Last Text', 'foodking-toolkit' ),
                    'default' => esc_html__( 'United States', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'hours_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Hours Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Hours:', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'hours_time', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Hours', 'foodking-toolkit' ),
                    'default' => esc_html__( '9.30am - 6.30pm', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'hours_day', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Days', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Monday to Friday', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );

            $this->add_control(
                'install_app_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Install App Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Install App', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'install_app_subtitle', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Install App Sub Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'From App Store or Google Play', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'app_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Install App Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'app_1_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'App Store Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'app_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Install App Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'app_2_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Play Store Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'support_center', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Support Text', 'foodking-toolkit' ),
                    'default' => esc_html__( '24/7 SUPPORT CENTER', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'support_number', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Support Number', 'foodking-toolkit' ),
                    'default' => esc_html__( '+1718-904-4450', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'support_number_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Number Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'copyright_text1', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Copyright Text 1', 'foodking-toolkit' ),
                    'default' => esc_html__( '© Copyright', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'copyright_text2', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Copyright Text 2', 'foodking-toolkit' ),
                    'default' => esc_html__( '2024', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'copyright_text3', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Copyright Text 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'All Rights Reserved.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'product_owner', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Product Ownership', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Foodking', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'product_owner_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Product Ownership Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'copyright_cradit_img',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Cradit Card Image', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'footer_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Content Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .footer-content p',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-content span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-content span',
                ]
            );
            $this->add_control(
                'email_color',
                [
                    'label' => esc_html__( 'Email Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-content .link' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Email Typography', 'foodking-toolkit' ),
                    'name' => 'email_typography',
                    'selector' => '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-content .link',
                ]
            );
            
            $this->add_control(
                'widget_head_color',
                [
                    'label' => esc_html__( 'Widget Head Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .widget-head h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Widget Head Typography', 'foodking-toolkit' ),
                    'name' => 'widget_head_typography',
                    'selector' => '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .widget-head h4',
                ]
            );
            $this->add_control(
                'menu_color_1',
                [
                    'label' => esc_html__( 'Quick Links Menu Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .menu-footer-menu-1-container ul li a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'menu_hover_color_1',
                [
                    'label' => esc_html__( 'Quick Links Menu Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .menu-footer-menu-1-container ul li a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Quick Links Menu Typography', 'foodking-toolkit' ),
                    'name' => 'menu_typography_1',
                    'selector' => '{{WRAPPER}} .menu-footer-menu-1-container ul li a',
                ]
            );
            $this->add_control(
                'menu_color_2',
                [
                    'label' => esc_html__( 'My Account Menu Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .menu-footer-menu-2-container ul li a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'menu_hover_color_2',
                [
                    'label' => esc_html__( 'My Account Menu Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .menu-footer-menu-2-container ul li a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'My Account Menu Typography', 'foodking-toolkit' ),
                    'name' => 'menu_typography_2',
                    'selector' => '{{WRAPPER}} .menu-footer-menu-2-container ul li a',
                ]
            );
            $this->add_control(
                'address_text_color',
                [
                    'label' => esc_html__( 'Address Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-address-text h6' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'address_span_text_color',
                [
                    'label' => esc_html__( 'Address Span Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-address-text h6 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'hours_color',
                [
                    'label' => esc_html__( 'Hours Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-address-text h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'app_desc_color',
                [
                    'label' => esc_html__( 'App Description Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-apps-items h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'App Description Typography', 'foodking-toolkit' ),
                    'name' => 'app_desc_typography',
                    'selector' => '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .list-items li a',
                ]
            );
            $this->add_control(
                'app_number_color',
                [
                    'label' => esc_html__( 'Phone Number Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-widgets-wrapper .single-footer-widget .footer-apps-items .support-text h3 a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'footer_bottom_bg_color',
                [
                    'label' => esc_html__( 'Footer Bottom Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-bottom' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'footer_bottom_color_1',
                [
                    'label' => esc_html__( 'Footer Bottom Text Color 1', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-bottom .footer-bottom-wrapper p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'footer_bottom_color_3',
                [
                    'label' => esc_html__( 'Footer Bottom Text Color 2', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-bottom .footer-bottom-wrapper p a' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'footer_bottom_color_3_hover',
                [
                    'label' => esc_html__( 'Footer Bottom Text Color 2 Hover', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .footer-bottom .footer-bottom-wrapper p a:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Logo URL
        if ( ! empty( $settings['logo_link']['url'] ) ) {
            $this->add_link_attributes( 'logo_link', $settings['logo_link'] );
        }
        // Email URL
        if ( ! empty( $settings['email_link']['url'] ) ) {
            $this->add_link_attributes( 'email_link', $settings['email_link'] );
        }
        // App Store URL
        if ( ! empty( $settings['app_1_link']['url'] ) ) {
            $this->add_link_attributes( 'app_1_link', $settings['app_1_link'] );
        }
        // Play Store URL
        if ( ! empty( $settings['app_2_link']['url'] ) ) {
            $this->add_link_attributes( 'app_2_link', $settings['app_2_link'] );
        }
        // Support Number URL
        if ( ! empty( $settings['support_number_link']['url'] ) ) {
            $this->add_link_attributes( 'support_number_link', $settings['support_number_link'] );
        }
        // Company URL
        if ( ! empty( $settings['product_owner_link']['url'] ) ) {
            $this->add_link_attributes( 'product_owner_link', $settings['product_owner_link'] );
        }
        ?>
    
    <!-- Footer Section Start -->
    <footer class="footer-section fix section-bg">
        <div class="burger-shape">
            <?php if($settings['shape_image_1']['url']) : ?>
                <img src="<?php echo esc_url($settings['shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif;?>
        </div>
        <div class="fry-shape">
            <?php if($settings['shape_image_2']['url']) : ?>
                <img src="<?php echo esc_url($settings['shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif;?>
        </div>
        <div class="container">
            <div class="footer-widgets-wrapper">
                <div class="row">
                    <div class="col-xl-3 col-sm-6 col-md-6 col-lg-3 wow fadeInUp" data-wow-delay=".2s">
                        <div class="single-footer-widget">
                            <div class="widget-head">
                                <?php if($settings['footer_logo']['url']) : ?>
                                    <a <?php echo $this->get_render_attribute_string('logo_link'); ?>>
                                        <img src="<?php echo esc_url($settings['footer_logo']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    </a>
                                <?php endif;?>
                            </div>
                            <div class="footer-content">
                                <p>
                                    <?php echo esc_html($settings['short_desc_1']);?> <br>
                                    <?php echo esc_html($settings['short_desc_2']);?>
                                </p>
                                <span><?php echo esc_html($settings['sub_title']);?></span> <br>
                                <a <?php echo $this->get_render_attribute_string('email_link'); ?> class="link"><?php echo esc_html($settings['email_address']);?></a>

                                <ul class="social-icon d-flex align-items-center">
                                    <?php foodking_social_link(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-2 ps-lg-5 col-sm-6 col-md-3 col-lg-3 wow fadeInUp" data-wow-delay=".4s">
                        <div class="single-footer-widget">
                            <div class="widget-head">
                                <h4><?php echo esc_html($settings['quick_links_title']);?></h4>
                            </div>
                            <?php
                                // Displaying the registered menu in your theme footer
                                wp_nav_menu( array(
                                    'theme_location' => 'footer-menu1',
                                ) );
                            ?>
                        </div>
                    </div>

                    <div class="col-xl-2 ps-lg-4 col-sm-6 col-md-3 col-lg-3 wow fadeInUp" data-wow-delay=".6s">
                        <div class="single-footer-widget">
                            <div class="widget-head">
                                <h4><?php echo esc_html($settings['my_accounts_title']);?></h4>
                            </div>
                            <?php
                                // Displaying the registered menu in your theme footer
                                wp_nav_menu( array(
                                    'theme_location' => 'footer-menu2',
                                ) );
                            ?>
                        </div>
                    </div>

                    <div class="col-xl-2 col-sm-6 col-md-6 col-lg-3 wow fadeInUp" data-wow-delay=".8s">
                        <div class="single-footer-widget">
                            <div class="widget-head">
                                <h4><?php echo esc_html($settings['address_title']);?></h4>
                            </div>
                            <div class="footer-address-text">
                                <h6>
                                    <?php echo esc_html($settings['address_text_1']);?> <span><?php echo esc_html($settings['address_text_2']);?></span>
                                    <?php echo esc_html($settings['address_text_3']);?>
                                </h6>
                                <h5><?php echo esc_html($settings['hours_title']);?></h5>
                                <h6>
                                    <?php echo esc_html($settings['hours_time']);?> <br>
                                    <?php echo esc_html($settings['hours_day']);?>
                                </h6>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 ps-xl-5 col-sm-6 col-md-6 col-lg-4 wow fadeInUp" data-wow-delay=".9s">
                        <div class="single-footer-widget">
                            <div class="widget-head">
                                <h4><?php echo esc_html($settings['install_app_title']);?></h4>
                            </div>
                            <div class="footer-apps-items">
                                <h5><?php echo esc_html($settings['install_app_subtitle']);?></h5>
                                <div class="apps-image d-flex align-items-center">
                                    <?php if($settings['app_image_1']['url']) : ?>
                                        <a <?php echo $this->get_render_attribute_string('app_1_link'); ?>>
                                            <img src="<?php echo esc_url($settings['app_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                        </a>
                                    <?php endif;?>

                                    <?php if($settings['app_image_2']['url']) : ?>
                                        <a <?php echo $this->get_render_attribute_string('app_2_link'); ?>>
                                            <img src="<?php echo esc_url($settings['app_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                        </a>
                                    <?php endif;?>
                                </div>


                                <div class="support-text">
                                    <h5><?php echo esc_html($settings['support_center']);?></h5>
                                    <h3><a <?php echo $this->get_render_attribute_string('support_number_link'); ?>><?php echo esc_html($settings['support_number']);?></a></h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="footer-bottom">
            <div class="container">
                <div class="footer-bottom-wrapper d-flex align-items-center justify-content-between">
                    <p>
                    <?php echo esc_html($settings['copyright_text1']);?> <span class="theme-color-3"><?php echo esc_html($settings['copyright_text2']);?></span> <a <?php echo $this->get_render_attribute_string('product_owner_link'); ?>><?php echo esc_html($settings['product_owner']);?> </a>. <?php echo esc_html($settings['copyright_text3']);?>
                    </p>
                    <div class="card-image">
                        <?php if($settings['copyright_cradit_img']['url']) : ?>
                            <img src="<?php echo esc_url($settings['copyright_cradit_img']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                        <?php endif;?>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Footer_Widget );