<?php

namespace Elementor;
class Foodking_Gallery_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_gallery_one';
	}
    public function get_title() {
		return esc_html__( 'Image Slider One', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-photo-library';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'gallery_one_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'slider_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Image Carousel Slider 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'slider_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Image Carousel Slider 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'slider_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Image Carousel Slider 3', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'slider_image_4',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Image Carousel Slider 4', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'slider_image_5',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Image Carousel Slider 5', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'slider_image_6',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Image Carousel Slider 6', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'btn_link', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'gallery_one_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .fix',
                ]
            );
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $settings['btn_link']['url'] ) ) {
            $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
        }
        ?>
    <!-- Gallery Section Start -->
    <div class="gallery-section fix section-padding">
        <div class="container">
            <div class="array-button">
                <button class="array-prev"><i class="fas fa-long-arrow-alt-left"></i></button>
                <button class="array-next"><i class="fas fa-long-arrow-alt-right"></i></button>
            </div>
            <div class="swiper gallery-slider">
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="gallery-image">
                            <?php if($settings['slider_image_1']['url']):?>
                                <img src="<?php echo esc_url($settings['slider_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif;?>
                            <div class="icon">
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?>>
                                <i class="fas fa-link"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="gallery-image">
                            <?php if($settings['slider_image_2']['url']):?>
                                <img src="<?php echo esc_url($settings['slider_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif;?>
                            <div class="icon">
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?>>
                                <i class="fas fa-link"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="gallery-image">
                            <?php if($settings['slider_image_3']['url']):?>
                                <img src="<?php echo esc_url($settings['slider_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif;?>
                            <div class="icon">
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?>>
                                <i class="fas fa-link"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="gallery-image">
                            <?php if($settings['slider_image_4']['url']):?>
                                <img src="<?php echo esc_url($settings['slider_image_4']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif;?>
                            <div class="icon">
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?>>
                                <i class="fas fa-link"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="gallery-image">
                            <?php if($settings['slider_image_5']['url']):?>
                                <img src="<?php echo esc_url($settings['slider_image_5']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif;?>
                            <div class="icon">
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?>>
                                <i class="fas fa-link"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="gallery-image">
                            <?php if($settings['slider_image_6']['url']):?>
                                <img src="<?php echo esc_url($settings['slider_image_6']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                            <?php endif;?>
                            <div class="icon">
                                <a <?php echo $this->get_render_attribute_string('btn_link'); ?>>
                                <i class="fas fa-link"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Gallery_One_Widget );