<?php

namespace Elementor;
class Foodking_Hero_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_hero_two';
	}
    public function get_title() {
		return esc_html__( 'Hero Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-device-desktop';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'hero_two_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'hero_two_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Banner Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Shape Image 3', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'top_title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Top Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'crispy, every bite taste', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'title_1', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'hot spicy chiken burger', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'sub_content', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Sub Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'limited offer  /', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'price', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Price', 'foodking-toolkit' ),
                    'default' => esc_html__( '$5', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_text', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'order now', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_link', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Button Link', 'foodking-toolkit' ),
                    'default' => esc_html__( '#', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $repeater->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $repeater->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
            $repeater->add_control(
                'hero_right_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Hero Product Image', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_4',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Product Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
                'shape_image_5',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Product Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'hero_two_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .hero-section',
                ]
            );
            $this->add_control(
                'top_title_color',
                [
                    'label' => esc_html__( 'Top Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-2 .hero-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Top Title Typography', 'foodking-toolkit' ),
                    'name' => 'top_title_typography',
                    'selector' => '{{WRAPPER}} .hero-2 .hero-content p',
                ]
            );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-2 .hero-content h1' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .hero-2 .hero-content h1',
                ]
            );
            $this->add_control(
                'subtitle_color',
                [
                    'label' => esc_html__( 'Subtitle Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-2 .hero-content .price-text h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Subtitle Typography', 'foodking-toolkit' ),
                    'name' => 'subtitle_typography',
                    'selector' => '{{WRAPPER}} .hero-2 .hero-content .price-text h3',
                ]
            );
            $this->add_control(
                'price_color',
                [
                    'label' => esc_html__( 'Price Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .hero-2 .hero-content .price-text h2' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Price Typography', 'foodking-toolkit' ),
                    'name' => 'price_typography',
                    'selector' => '{{WRAPPER}} .hero-2 .hero-content .price-text h2',
                ]
            );
            //Start Button Style
            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Button Text Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_color',
                [
                    'label' => esc_html__( 'Button Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_hover_color',
                [
                    'label' => esc_html__( 'Button Text Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'button_bg_hover_color',
                [
                    'label' => esc_html__( 'Button Background Hover Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .theme-btn:hover' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Button Typography', 'foodking-toolkit' ),
                    'name' => 'button_typography',
                    'selector' => '{{WRAPPER}} .theme-btn',
                ]
            );
            //End Button Style
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
    
    <!-- Hero Section Start -->
    <section class="hero-section">
        <div class="swiper hero-slider">
            <div class="swiper-wrapper">
                <?php foreach($settings['lists'] as $item):?>
                    <div class="swiper-slide">
                        <div class="hero-2 bg-cover" style="background-image: url(<?php echo esc_url($item['hero_two_image_2']['url']);?>);">
                            <div class="left-shape" data-animation="fadeInUp" data-delay="2.2s">
                                <?php if($item['shape_image_1']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="chili-shape" data-animation="fadeInUp" data-delay="2.4s">
                                <?php if($item['shape_image_2']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="vagetable-shape" data-animation="fadeInUp" data-delay="2.8s">
                                <?php if($item['shape_image_3']['url']):?>
                                    <img src="<?php echo esc_url($item['shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif; ?>
                            </div>
                            <div class="container"> 

                                <div class="row justify-content-between align-items-center">
                                    <div class="col-xl-6 col-lg-6">
                                        <div class="hero-content">
                                            <p data-animation="fadeInUp" data-delay="1.3s"><?php echo esc_html($item['top_title']);?></p>
                                            <h1  data-animation="fadeInUp" data-delay="1.5s">
                                                <?php echo esc_html($item['title_1']);?>
                                            </h1>
                                            <div data-animation="fadeInUp" data-delay="1.7s" class="price-text">
                                                <h3><?php echo esc_html($item['sub_content']);?></h3>
                                                <h2><?php echo esc_html($item['price']);?></h2>
                                            </div>
                                            <div class="hero-button">
                                                <?php if($item['btn_text']): ?>
                                                    <a href="<?php echo esc_html($item['btn_link']);?>" class="theme-btn" data-animation="fadeInUp" data-delay="1.9s">
                                                        <span class="button-content-wrapper d-flex align-items-center">
                                                            <span class="button-icon">
                                                                <?php if($item['btn_icon_type'] == 'theme'): ?>
                                                                <i class="<?php echo esc_attr($item['btn_icon']); ?>"></i>
                                                                <?php else: ?>
                                                                    <?php Icons_Manager::render_icon( $item['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                                                                <?php endif; ?>
                                                            </span>
                                                            <span class="button-text"><?php echo esc_html($item['btn_text']);?></span>
                                                        </span>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-6 col-lg-6 mt-5 mt-lg-0">
                                        <div class="burger-image" data-animation="fadeInUp" data-delay="1.4s">
                                                <?php if($item['hero_right_image']['url']):?>
                                                    <img src="<?php echo esc_url($item['hero_right_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                <?php endif; ?>
                                            <div class="burger-text" data-animation="fadeInUp" data-delay="1.6s">
                                                <?php if($item['shape_image_4']['url']):?>
                                                    <img src="<?php echo esc_url($item['shape_image_4']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                <?php endif; ?>
                                            </div>
                                            <div class="hero-text" data-animation="fadeInUp" data-delay="1.8s">
                                                <?php if($item['shape_image_5']['url']):?>
                                                    <img src="<?php echo esc_url($item['shape_image_5']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach;?>
            </div>
        </div>
        <div class="swiper-dot text-center pt-5">
            <div class="dot"></div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Hero_Two_Widget );