<?php

namespace Elementor;
class Foodking_Instagram_Banner_Two_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_instagram_banner_two';
	}
    public function get_title() {
		return esc_html__( 'Instagram Banner Two', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-slider-3d';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor Slider Section Control
		$this->start_controls_section(
			'instagram_banner_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $repeater = new Repeater();
            $repeater->add_control(
                'slider_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Slider Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add List Content', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'slider_section_style',
			[
				'label' => __( 'Slider Two Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .heroSlider',
                ]
            );
            
        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

    <!-- Instagram Banner Section Start -->
    <div class="instagram-banner fix">
        <div class="swiper instagram-banner-slider">
            <div class="swiper-wrapper">
                <?php foreach ($settings['lists'] as $item):?>
                    <div class="swiper-slide">
                        <div class="instagram-banner-items style-2">
                            <?php if($item['slider_image_1']['url']):?>
                                <div class="banner-image">
                                    <img src="<?php echo esc_url($item['slider_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                    <?php 
                                        // Get the URL of the image being displayed
                                        $image_url = $item['slider_image_1']['url'];
                                        
                                        // Output the anchor tag with a dynamic href attribute
                                        echo '<a href="' . esc_url($image_url) . '" class="icon img-popup"><i class="fas fa-search"></i></a>';
                                    ?>
                                </div>
                            <?php endif;?>
                        </div>
                    </div>
                <?php endforeach;?>
            </div>
        </div>
    </div>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Instagram_Banner_Two_Widget );