<?php
/**
 * Product Category
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Foodking_Categories extends Widget_Base {

	public function get_name() {
        return 'Foodking_Categories';
    }

	public function get_title() {
        return __( 'Categories', 'foodking-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'foodking-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'foodking_categories',
			[
				'label' => __( 'Categories Control', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'top_title',
            [
                'label'       => __( 'Top Title', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('ترد، هر لقمه ای', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('اقلام غذایی محبوب', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
        $this->add_control(
            'area_shape1',
            [
                'label' => __( 'Area Shape One', 'foodking-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );
        $this->add_control(
            'area_shape2',
            [
                'label' => __( 'Area Shape Two', 'foodking-toolkit' ),
                'type' => Controls_Manager::MEDIA,
            ]
        );

			$repeater = new Repeater();

            $repeater->add_control(
                'cat_name', [
					'type'          => Controls_Manager::SELECT,
					'label_block' 	=> true,
					'options' 		=> foodking_toolkit_get_page_product_cat_el(),
					'label'         => esc_html__( 'Select Category', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
				'cat_shape',
				[
					'label' => esc_html__( 'Category Shape', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
            );
            $repeater->add_control(
				'product_img',
				[
					'label' => esc_html__( 'Product Image', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
            );
            $repeater->add_control(
				'sm_shape1',
				[
					'label' => esc_html__( 'Small Shape One', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
            );
            $repeater->add_control(
				'sm_shape2',
				[
					'label' => esc_html__( 'Small Shape Two', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
            );
            $repeater->add_control(
				'sm_shape3',
				[
					'label' => esc_html__( 'Small Shape Three', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
            );
            $repeater->add_control(
				'text_shape',
				[
					'label' => esc_html__( 'Text Shape', 'foodking-toolkit' ),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
				]
            );
            
            $repeater->add_control(
                'content', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Total Products Text', 'foodking-toolkit' ),
					'default' => esc_html__('محصولات', 'foodking-toolkit'),
                ]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Item', 'foodking-toolkit' ),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                ]
            );

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'top_title_color',
            [
                'label'     => __( 'Top Title Color', 'foodking-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'top_title_typography',
                'label'    => __( 'Top Title Typography', 'foodking-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title span',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'foodking-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'foodking-toolkit' ),
                'selector' => '{{WRAPPER}} .section-title h2',
            ]
        );
            $this->add_control(
                'card_title_color',
                [
                    'label' => esc_html__( 'Card Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .catagory-product-card .catagory-product-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'card_title_typography',
                    'label' => __( 'Card Title Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .catagory-product-card .catagory-product-content h3',
                ]
            );
            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Content Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .catagory-product-card .catagory-product-content p' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'content_typography',
                    'label' => __( 'Content Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .catagory-product-card .catagory-product-content p',
                ]
            );
            $this->add_control(
                'card_bg_color',
                [
                    'label' => esc_html__( 'Card Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .catagory-product-card' => 'Background: {{VALUE}}',
                    ],
                ]
            );
        $this->add_control(
            'card_bg_color_trans',
            [
                'label' => esc_html__( 'رنگ افکت زمینه', 'foodking-toolkit' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .catagory-product-card::after' => 'Background: {{VALUE}}',
                ],
            ]
        );
            $this->add_control(
                'card_a_bg_color',
                [
                    'label' => esc_html__( 'Card Hover Background Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .catagory-product-card::before' => 'Background-color: {{VALUE}}',
                    ],
                ]
            );
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>

        <!-- Food Catagory Section Start -->
        <section class="food-category-section fix section-padding section-bg">
            <div class="tomato-shape">
                <?php if( $settings['area_shape1']['url'] != '' ): ?>
                    <img src="<?php echo esc_url( $settings['area_shape1']['url'] ) ?>" alt="image">
                <?php endif; ?>
            </div>
            <div class="burger-shape-2">
                <?php if( $settings['area_shape2']['url'] != '' ): ?>
                    <img src="<?php echo esc_url( $settings['area_shape2']['url'] ) ?>" alt="image">
                <?php endif; ?>
            </div>
            <div class="container">
                <div class="row">
                    <div class="col-md-7 col-9">
                        <div class="section-title">
                            <?php if( $settings['top_title']): ?>
                                <span class="wow fadeInUp"><?php echo wp_kses_post( $settings['top_title'] ); ?></span>
                            <?php endif; ?> 
                            <?php if( $settings['title']): ?>
                                <h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo wp_kses_post( $settings['title'] ); ?></h2>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-5 ps-0 col-3 text-end-tt wow fadeInUp" data-wow-delay=".5s">
                        <div class="array-button">
                            <button class="array-prev"><i class="far fa-long-arrow-left"></i></button>
                            <button class="array-next"><i class="far fa-long-arrow-right"></i></button>
                        </div>
                    </div>
                </div>
                <div class="swiper food-catagory-slider">
                    <div class="swiper-wrapper">
                    <?php 
                        $i = 1;
                        foreach ($settings['items'] as $item) {
                        if ($item['cat_name']) {
                            $taxonomy = 'product_cat';
                            $cat_link = get_term_link($item['cat_name'], $taxonomy);
                            $category = get_term_by('slug', $item['cat_name'], $taxonomy);
                            if ($category) {
                                $count = $category->count;
                                $category_link = get_term_link($category);
                                $title = $category->name;
                            } else {
                                $count = '';
                                $category_link = '';
                                $title = '';
                            }
                            if(isset($category->name)):
                                $cat_name = $category->name;
                                $args = array(
                                    'orderby' => 'slug',
                                    'parent' => 0,
                                    'taxonomy' => $taxonomy,
                                    'field' => 'slug',
                                );
                            ?>
                        <div class="swiper-slide">
                            <div class="catagory-product-card bg-cover" style="background-image:url(<?php echo esc_url( $item['cat_shape']['url'] ); ?>);">
                                <div class="catagory-product-image text-center">
                                    <a href="<?php echo esc_url($cat_link); ?>">
                                        <?php if ($item['product_img']['url'] != '') { ?>
                                            <img src="<?php echo esc_url($item['product_img']['url']); ?>" alt="Image">
                                        <?php } ?>
                                        <div class="decor-leaf">
                                            <?php if ($item['sm_shape1']['url'] != '') { ?>
                                                <img src="<?php echo esc_url($item['sm_shape1']['url']); ?>" alt="Image">
                                            <?php } ?>
                                        </div>
                                        <div class="decor-leaf-2">
                                            <?php if ($item['sm_shape2']['url'] != '') { ?>
                                                <img src="<?php echo esc_url($item['sm_shape2']['url']); ?>" alt="Image">
                                            <?php } ?>
                                        </div>
                                        <div class="burger-shape">
                                            <?php if ($item['sm_shape3']['url'] != '') { ?>
                                                <img src="<?php echo esc_url($item['sm_shape3']['url']); ?>" alt="Image">
                                            <?php } ?>
                                        </div>
                                    </a>
                                </div>
                                <div class="catagory-product-content text-center">
                                    <div class="catagory-product-icon">
                                        <?php if ($item['text_shape']['url'] != '') { ?>
                                            <img src="<?php echo esc_url($item['text_shape']['url']); ?>" alt="Image">
                                        <?php } ?>
                                    </div>
                                    <h3>
                                        <a href="<?php echo esc_url($cat_link); ?>">
                                        <?php echo esc_html($cat_name); ?>
                                        </a>
                                    </h3>
                                    <p><?php echo esc_html($count); ?> <?php echo esc_html($item['content']); ?></p>
                                </div>
                            </div>
                        </div>
                        <?php 
                            endif;
                            $i++; 
                            } 
                        } ?>
                    </div>
                </div>
            </div>
        </section>
        <?php
	}

}

Plugin::instance()->widgets_manager->register( new Foodking_Categories );