<?php
/**
 * Product Category
 */

namespace Elementor;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Foodking_Product_SidebarCat extends Widget_Base {

	public function get_name() {
        return 'Foodking_SidebarCat';
    }

	public function get_title() {
        return __( 'Sidebar Categories', 'foodking-toolkit' );
    }

	public function get_icon() {
        return 'eicon-gallery-group';
    }

	public function get_categories() {
        return [ 'foodking-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
			'foodking_categories',
			[
				'label' => __( 'Sidebar Categories', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'foodking-toolkit' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __('CATAGORIES', 'foodking-toolkit'),
                'label_block' => true,
            ]
        );
			$repeater = new Repeater();

            $repeater->add_control(
                'cat_name', [
					'type'          => Controls_Manager::SELECT,
					'label_block' 	=> true,
					'options' 		=> foodking_toolkit_get_page_product_cat_el(),
					'label'         => esc_html__( 'Select Category', 'foodking-toolkit' ),
                ]
            );
            $repeater->add_control(
				'cat_icon',
				[
					'label'      => esc_html__( 'Category Icon', 'foodking-toolkit' ),
                    'type'        => Controls_Manager::TEXT,
                    'label_block' => true,
				]
            );
            $this->add_control(
                'items',
                [
                    'label'   => esc_html__( 'Add Item', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
       
        $this->add_control(
            'title_color',
            [
                'label'     => __( 'Title Color', 'foodking-toolkit' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .main-sidebar .single-sidebar-widget .wid-title h4' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'label'    => __( 'Title Typography', 'foodking-toolkit' ),
                'selector' => '{{WRAPPER}} .main-sidebar .single-sidebar-widget .wid-title h4',
            ]
        );
            $this->add_control(
                'cat_title_color',
                [
                    'label' => esc_html__( 'Category Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .main-sidebar .single-sidebar-widget .widget-categories ul li' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'cat_typography',
                    'label' => __( 'Category Typography', 'foodking-toolkit' ),
                    'selector' => '{{WRAPPER}} .main-sidebar .single-sidebar-widget .widget-categories ul li',
                ]
            );
           
        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="wid-title">
            <?php if( $settings['title']): ?>
                <h4><?php echo wp_kses_post( $settings['title'] ); ?></h4>
            <?php endif; ?>
        </div>
        <div class="widget-categories">
            <ul>
                <?php $i = 1;
                foreach ($settings['items'] as $item) :
                    $cat_link = get_term_link( $item['cat_name'], 'product_cat' );
                    $category = get_term_by('slug', $item['cat_name'], 'product_cat');
                    $cat_name = $category->name;
                    $cat_count = $category->count;
                ?>
                    <li><a href="<?php echo esc_url($cat_link); ?>"><i class="<?php echo esc_attr($item['cat_icon']); ?>"></i><?php echo esc_html($cat_name); ?></a></li>

                <?php $i++; endforeach; ?>
            </ul>
        </div>
        <?php
	}
}

Plugin::instance()->widgets_manager->register( new Foodking_Product_SidebarCat );