<?php

namespace Elementor;
class Foodking_Reservation_Details_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_reservation_details';
	}
    public function get_title() {
		return esc_html__( 'Team Reservation', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-select';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    protected function register_controls() {

        // Elementor About Section Control
		$this->start_controls_section(
			'reservation_section',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'shortcode',
                [
                    'label' => esc_html__( 'Reservation Contact Form 7 PLugin Short code', 'foodking-toolkit' ),
                    'type' => Controls_Manager::TEXTAREA,
                ]
            );
            $this->add_control(
                'reservation_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Reservation Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Create An ', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'reservation_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Reservation Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Reservation........', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'reservation_content',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Reservation Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Your email address will not be published. Required fields are marked *', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'reservation_left_title',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Reservation Left Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'GET IN TOUCH', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'reservation_left_content',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Reservation Left Content', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Lorem ipsum dolor sit amet consectetur adipiscing elit mattis
                    faucibus odio feugiat arc dolor.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'left_contact_title_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Title 1', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Contact', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'left_contact_content_1',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Phone Number', 'foodking-toolkit' ),
                    'default' => esc_html__( '+1718-904-4450', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link_1', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Phone Number Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'left_contact_title_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Title 2', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Email', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'left_contact_content_2',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Email Address', 'foodking-toolkit' ),
                    'default' => esc_html__( 'info@example.com', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'btn_link_2', [
					'type'    => Controls_Manager::URL,
                    'options' => [ 'url', 'is_external', 'nofollow' ],
					'label'   => esc_html__( 'Phone Number Link', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'left_contact_title_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Title 3', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Address', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'left_contact_content_3',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Contact Address', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Jackpark, Ghana', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'reservation_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            
        $this->end_controls_section();
    }
    
    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        // Button URL
        if ( ! empty( $item['btn_link_1']['url'] ) ) {
            $this->add_link_attributes( 'btn_link_1', $item['btn_link_1'] );
        }
        // Button URL
        if ( ! empty( $item['btn_link_2']['url'] ) ) {
            $this->add_link_attributes( 'btn_link_2', $item['btn_link_2'] );
        }
        ?>
    <!-- Team Reservation Section Start -->
    <section class="team-reservation fix section-padding">
        <div class="container">
            <div class="team-reservation-wrapper">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="get-touch-items">
                            <div class="get-touch-title">
                                <h2 class="wow fadeInUp"><?php echo esc_html($settings['reservation_left_title']);?></h2>
                                <p class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['reservation_left_content']);?></p>
                            </div>
                            <div class="contact-items">
                                <div class="contact-info wow fadeInUp" data-wow-delay=".3s">
                                    <h4><?php echo esc_html($settings['left_contact_title_1']);?></h4>
                                    <h5><a <?php echo $this->get_render_attribute_string('btn_link_1'); ?>><?php echo esc_html($settings['left_contact_content_1']);?></a></h5>
                                </div>
                                <div class="contact-info wow fadeInUp" data-wow-delay=".5s">
                                    <h4><?php echo esc_html($settings['left_contact_title_2']);?></h4>
                                    <h5><a <?php echo $this->get_render_attribute_string('btn_link_2'); ?> class="link"><?php echo esc_html($settings['left_contact_content_2']);?></a></h5>
                                </div>
                            </div>
                            <div class="contact-items">
                                <div class="contact-info wow fadeInUp" data-wow-delay=".3s">
                                    <h4><?php echo esc_html($settings['left_contact_title_3']);?></h4>
                                    <h5><?php echo esc_html($settings['left_contact_content_3']);?></h5>
                                </div>
                                <div class="contact-info wow fadeInUp" data-wow-delay=".5s">
                                    <h4><?php esc_html_e('Follow','foodking-toolkit');?></h4>
                                    <ul class="social-icon d-flex align-items-center">
                                        <?php foodking_social_link(); ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 mt-5 mt-lg-0 wow fadeInUp" data-wow-delay=".4s">
                        <div class="team-reservation-items">
                            <div class="reservation-title">
                                <h3><?php echo esc_html($settings['reservation_title_1']);?> <span ><?php echo esc_html($settings['reservation_title_2']);?></span></h3>
                                <p><?php echo esc_html($settings['reservation_content']);?></p>
                            </div>
                            <?php echo do_shortcode( $settings['shortcode'] ); ?><!-- Contact Form 7 Short Code -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php

    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Reservation_Details_Widget );