<?php

namespace Elementor;
class Foodking_Testimonial_One_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_testimonial_one';
	}
    public function get_title() {
		return esc_html__( 'Testimonial One', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-commenting-o';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    public function get_keywords() {
		return [ 'testimonial' ];
	}

    protected function register_controls() {
        // Elementor Section Control
		$this->start_controls_section(
			'testimonial_controls',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'shape_image_1',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 1', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_image_2',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 2', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_image_3',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image 3', 'foodking-toolkit' ),
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'client_name', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Name', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Piter Bowman', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'client_designation', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Designation', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Business CEO & co founder', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'testimonial_comment',
                [
                    'type' =>Controls_Manager::TEXT,
                    'label' => esc_html__( 'Client Says', 'foodking-toolkit' ),
                    'default' => esc_html__( '“Thank you for dinner last night. It was amazing!! I have
                    say it’s the best meal I have had in quite some time.
                    will definitely be seeing more eating next year.”', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $repeater->add_control(
                'icon_1',
                [
                    'label' => esc_html__( 'Ratings Icons #1', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_2',
                [
                    'label' => esc_html__( 'Ratings Icons #2', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_3',
                [
                    'label' => esc_html__( 'Ratings Icons #3', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_4',
                [
                    'label' => esc_html__( 'Ratings Icons #4', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'icon_5',
                [
                    'label' => esc_html__( 'Ratings Icons #5', 'foodking-toolkit' ),
                    'type' => Controls_Manager::ICON,
                ]
            );
            $repeater->add_control(
                'client_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Client Image', 'foodking-toolkit' ),
                ]
            );
            
            $this->add_control(
                'lists',
                [
                    'label'   => esc_html__( 'Add Testimonial', 'foodking-toolkit' ),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'testimonial_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .section-bg',
                ]
            );

            $this->add_control(
                'ratings_color',
                [
                    'label' => esc_html__( 'Ratings Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .star span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Ratings Typography', 'foodking-toolkit' ),
                    'name' => 'ratings_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .star span',
                ]
            );

            $this->add_control(
                'testimony_content_color',
                [
                    'label' => esc_html__( 'Comment Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Comment Typography', 'foodking-toolkit' ),
                    'name' => 'testimony_content_typography',
                    'selector' => '{{WRAPPER}} .testimonial-content h3',
                ]
            );

            $this->add_control(
                'commenter_color',
                [
                    'label' => esc_html__( 'Person Name Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Name Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h4',
                ]
            );

            $this->add_control(
                'commenter_designation_color',
                [
                    'label' => esc_html__( 'Person Designation Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h5' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Designation Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_designation_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper .testimonial-items .testimonial-content .client-info h5',
                ]
            );

        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
    <!-- Testimonial Section Start -->
    <section class="testimonial-section fix section-padding section-bg">
        <div class="burger-shape">
            <?php if($settings['shape_image_1']['url']):?>
                <img src="<?php echo esc_url($settings['shape_image_1']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif; ?>
        </div>
        <div class="fry-shape">
            <?php if($settings['shape_image_2']['url']):?>
                <img src="<?php echo esc_url($settings['shape_image_2']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif; ?>
        </div>
        <div class="pizza-shape">
            <?php if($settings['shape_image_3']['url']):?>
                <img src="<?php echo esc_url($settings['shape_image_3']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
            <?php endif; ?>
        </div>
        <div class="container">
            <div class="row">
                <div class="testimonial-wrapper style-responsive">
                    <div class="testimonial-items text-center">
                        <div class="swiper testimonial-content-slider">
                            <div class="swiper-wrapper">
                                <?php foreach($settings['lists'] as $item):?>
                                    <div class="swiper-slide">
                                        <div class="testimonial-content">
                                            <div class="client-info">
                                                <h4><?php echo esc_html($item['client_name']);?></h4>
                                                <h5><?php echo esc_html($item['client_designation']);?></h5>
                                            </div>
                                            <h3><?php echo esc_html($item['testimonial_comment']); ?></h3>
                                            <div class="star">
                                                <span class="<?php echo esc_attr( $item['icon_1'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_2'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_3'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_4'] ); ?>"></span>
                                                <span class="<?php echo esc_attr( $item['icon_5'] ); ?>"></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach;?>
                            </div>
                        </div>
                        
                        <div class="swiper testimonial-image-slider">
                            <div class="swiper-wrapper">
                                <?php foreach($settings['lists'] as $item2):?>
                                    <div class="swiper-slide">
                                        <?php if($item2['client_image']['url']):?>
                                            <div class="client-image-item">
                                                <div class="client-img bg-cover" style="background-image: url(<?php echo esc_url($item2['client_image']['url']);?>)"></div>
                                            </div>
                                        <?php endif;?>
                                    </div>
                                <?php endforeach;?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Testimonial_One_Widget );