<?php

namespace Elementor;
class Foodking_Testimonial_Three_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_testimonial_three';
	}
    public function get_title() {
		return esc_html__( 'Testimonial Three', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-commenting-o';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    public function get_keywords() {
		return [ 'testimonial' ];
	}

    protected function register_controls() {
        // Elementor Section Control
		$this->start_controls_section(
			'testimonial_controls',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'section_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Cover Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'shape_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Shape Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'title', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Feedback Title', 'foodking-toolkit' ),
                    'default' => esc_html__( 'LEARN SOMETHING FOODKING', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'content', [
					'type'    => Controls_Manager::TEXTAREA,
					'label'   => esc_html__( 'Feedback', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Welcome to our culinary haven, where each dish is a symphony of flavors meticulously crafted tantalize your taste buds. Nestled in the heart of [City], our restaurant is an inviting space that combines.', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'avatar',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Avatar Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'client_name', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Name', 'foodking-toolkit' ),
                    'default' => esc_html__( 'Michael V. Christensen / ', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
            $this->add_control(
                'client_designation', [
					'type'    => Controls_Manager::TEXT,
					'label'   => esc_html__( 'Client Designation', 'foodking-toolkit' ),
                    'default' => esc_html__( 'CEO & Founder', 'foodking-toolkit' ),
                    'label_block' 	=> true,
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'testimonial_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .testimonial-section-3',
                ]
            );

            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Title Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Title Typography', 'foodking-toolkit' ),
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content h4',
                ]
            );

            $this->add_control(
                'content_color',
                [
                    'label' => esc_html__( 'Comment Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content h3' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Comment Typography', 'foodking-toolkit' ),
                    'name' => 'content_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content h3',
                ]
            );

            $this->add_control(
                'commenter_color',
                [
                    'label' => esc_html__( 'Person Name Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content .client-info .title h4' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Name Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content .client-info .title h4',
                ]
            );

            $this->add_control(
                'commenter_designation_color',
                [
                    'label' => esc_html__( 'Person Designation Color', 'foodking-toolkit' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content .client-info .title h4 span' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'label' => esc_html__( 'Person Designation Typography', 'foodking-toolkit' ),
                    'name' => 'commenter_designation_typography',
                    'selector' => '{{WRAPPER}} .testimonial-wrapper-3 .testimonial-content .client-info .title h4 span',
                ]
            );

        $this->end_controls_section();
    }

    // Render
    protected function render() {
		$settings = $this->get_settings_for_display();
        ?>
        
    <!-- Testimonial Section Start -->
    <section class="testimonial-section-3 section-padding fix">
        <div class="container">
            <div class="testimonial-wrapper-3">
                <div class="row align-items-center">
                    <div class="col-xl-5 col-lg-5 wow fadeInUp" data-wow-delay=".3s">
                        <div class="testimonial-image bg-cover" style="background-image: url(<?php echo esc_url($settings['section_image']['url']);?>);">
                            <div class="shape-image">
                                <?php if($settings['shape_image']['url']):?>
                                    <img src="<?php echo esc_url($settings['shape_image']['url']);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking-toolkit');?>">
                                <?php endif;?>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 mt-5 mt-lg-0">
                        <div class="testimonial-content">
                            <h4 class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($settings['title']);?></h4>
                            <h3 class="wow fadeInUp" data-wow-delay=".5s"><?php echo wp_kses_post($settings['content']);?></h3>
                            <?php if($settings['avatar']['url']):?>
                                <div class="client-info d-flex align-items-center wow fadeInUp" data-wow-delay=".7s">
                                    <div class="client-image bg-cover" style="background-image: url(<?php echo esc_url($settings['avatar']['url']);?>);"></div>
                                    <div class="title">
                                        <h4><?php echo esc_html($settings['client_name']);?><span><?php echo esc_html($settings['client_designation']);?></span></h4>
                                    </div>
                                </div>
                            <?php endif;?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Testimonial_Three_Widget );