<?php

namespace Elementor;
class Foodking_Video_Banner_Widget extends Widget_Base {
	public function get_name() {
		return 'foodking_video_banner';
	}
    public function get_title() {
		return esc_html__( 'Video Banner', 'foodking-toolkit' );
	}
    public function get_icon() {
		return 'eicon-youtube';
	}
	public function get_categories() {
		return [ 'foodking-elements' ];
	}
    public function get_keywords() {
		return [ 'video', 'banner' ];
	}
    protected function register_controls() {

        // Elementor Hero Section Control
		$this->start_controls_section(
			'video_banner_content',
			[
				'label' => esc_html__( 'Content', 'foodking-toolkit' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'btn_icon_type',
                [
                    'label' => esc_html__( 'Button Icon Type', 'foodking-toolkit' ),
                    'type' => Controls_Manager::SELECT,
                    'label_block' => true,
                    'options' => [
                        'elementor'  => esc_html__( 'Elementor Icons', 'foodking-toolkit' ),
                        'theme' => esc_html__( 'Theme Icons', 'foodking-toolkit' ),
                    ],
                ]
            );
            $this->add_control(
                'btn_icon_el',
                [
                    'type' =>Controls_Manager::ICONS,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'condition' => [
                        'btn_icon_type' => 'elementor',
                    ]
                ]
            );
            $this->add_control(
                'btn_icon',
                [
                    'type' =>Controls_Manager::ICON,
                    'label' => esc_html__( 'Button Icon', 'foodking-toolkit' ),
                    'label_block' => true,
                    'options' => foodking_icons(),
                    'condition' => [
                        'btn_icon_type' => 'theme',
                    ]
                ]
            );
            $this->add_control(
                'video_btn_image',
                [
                    'type' =>Controls_Manager::MEDIA,
                    'label' => esc_html__( 'Video Section Background Image', 'foodking-toolkit' ),
                ]
            );
            $this->add_control(
                'video_btn_link', [
                    'type'    => Controls_Manager::TEXT,
                    'label'   => esc_html__( 'Video ID', 'foodking-toolkit' ),
                ]
            );
        $this->end_controls_section();
        
        // Elementor Style Control
        $this->start_controls_section(
			'video_banner_style',
			[
				'label' => __( 'Style', 'foodking-toolkit' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->end_controls_section();
    }

    // Render
    protected function render() {
        $settings = $this->get_settings_for_display();
    ?>
    <!-- Video Banner Section Start -->
    <?php if($settings['video_btn_image']['url']):?>
        <div class="video-section section-padding bg-cover" style="background-image: url(<?php echo esc_url($settings['video_btn_image']['url']);?>);">
            <div class="container">
                <div class="video-icon center">
                    <a href="https://www.youtube.com/watch?v=<?php echo esc_attr($settings['video_btn_link']); ?>" class="video-popup">
                        <?php if($settings['btn_icon_type'] == 'theme'): ?>
                            <i class="<?php echo esc_attr($settings['btn_icon']); ?>"></i>
                        <?php else: ?>
                            <?php Icons_Manager::render_icon( $settings['btn_icon_el'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php endif; ?>
                    </a>
                </div>
            </div>
        </div>
    <?php endif;?>
    <?php
    }
}
Plugin::instance()->widgets_manager->register( new Foodking_Video_Banner_Widget );