<?php
// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );

// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );

 /**
 * Products category list
 */
function foodking_toolkit_get_page_product_cat_el(){
    $arg = array(
        'taxonomy' 	=> 'product_cat',
        'orderby' 	=> 'name',
        'order'   	=> 'ASC'
    );
    $args = get_categories($arg);
    $args_options = array(esc_html__('', 'foodking-toolkit') => '');
    if ($args) {
        foreach ($args as $args) {
            $args_options[$args->name] = $args->slug;
        }
    }
    $flipped = array_flip($args_options);
    return $flipped;
}

// Register Custom Post Type for team
function foodking_toolkit_teams() {
	$labels = array(
		'name'                  => _x( 'تیم', 'foodking-toolkit' ),
		'singular_name'         => _x( 'تیم', 'foodking-toolkit' ),
		'menu_name'             => __( 'تیم', 'foodking-toolkit' ),
		'name_admin_bar'        => __( 'تیم', 'foodking-toolkit' ),
		'archives'              => __( 'آرشیو اعضا', 'foodking-toolkit' ),
		'attributes'            => __( 'ویژگی های اعضا', 'foodking-toolkit' ),
		'parent_item_colon'     => __( 'Parent Item:', 'foodking-toolkit' ),
		'all_items'             => __( 'تمامی آیتم', 'foodking-toolkit' ),
		'add_new_item'          => __( 'افزودن آیتم جدید', 'foodking-toolkit' ),
		'add_new'               => __( 'افزودن جدید', 'foodking-toolkit' ),
		'new_item'              => __( 'آیتم جدید', 'foodking-toolkit' ),
		'edit_item'             => __( 'ویرایش آیتم', 'foodking-toolkit' ),
		'update_item'           => __( 'آپدیت آیتم', 'foodking-toolkit' ),
		'view_item'             => __( 'مشاهده آیتم', 'foodking-toolkit' ),
		'view_items'            => __( 'مشاهده آیتم', 'foodking-toolkit' ),
		'search_items'          => __( 'جستجو آیتم', 'foodking-toolkit' ),
		'not_found'             => __( 'چیزی یافت نشد!', 'foodking-toolkit' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'foodking-toolkit' ),
		'featured_image'        => __( 'Featured Image', 'foodking-toolkit' ),
		'set_featured_image'    => __( 'Set featured image', 'foodking-toolkit' ),
		'remove_featured_image' => __( 'Remove featured image', 'foodking-toolkit' ),
		'use_featured_image'    => __( 'Use as featured image', 'foodking-toolkit' ),
		'insert_into_item'      => __( 'Insert into item', 'foodking-toolkit' ),
		'uploaded_to_this_item' => __( 'Uploaded to this item', 'foodking-toolkit' ),
		'items_list'            => __( 'Items list', 'foodking-toolkit' ),
		'items_list_navigation' => __( 'Items list navigation', 'foodking-toolkit' ),
		'filter_items_list'     => __( 'Filter items list', 'foodking-toolkit' ),
	);
	$args = array(
		'label'                 => __( 'تیم', 'foodking-toolkit' ),
		'description'           => __( 'Team Post Type Description', 'foodking-toolkit' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'thumbnail', 'revisions', 'excerpt' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'menu_icon'             => 'dashicons-buddicons-buddypress-logo',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'teams', $args );

}
add_action( 'init', 'foodking_toolkit_teams', 0 );

add_filter( 'body_class', function( $classes ) {
    return array_merge( $classes, array( 'foodking-toolkit-cus-class' ) );
} );

add_filter('wpcf7_autop_or_not', '__return_false');
