<?php
/**
 * Register  Reusable Content Blocks post type.
 *
 * @package reusablec-block
 *
 */
  
$labels = array(
	'name'               => _x( 'بلوک های فودکینگ', 'foodking-toolkit' ),
	'singular_name'      => _x( 'بلوک مواد فودکینگ', 'foodking-toolkit' ),
	'add_new'            => _x( 'مورد جدید اضافه کن ', 'foodking-toolkit' ),
	'add_new_item'       => _x( 'بلوک جدید اضافه کنید', 'foodking-toolkit' ),
	'edit_item'          => _x( 'بلوک ویرایش', 'foodking-toolkit' ),
	'new_item'           => _x( 'بلوک جدید', 'foodking-toolkit' ),
	'all_items'          => _x( 'همه بلوک ها', 'foodking-toolkit' ),
	'view_item'          => _x( 'مشاهده بلوک', 'foodking-toolkit' ),
	'search_items'       => _x( 'بلوک های جستجو', 'foodking-toolkit' ),
	'not_found'          =>  _x( 'هیچ بلوکی یافت نشد', 'foodking-toolkit' ),
	'not_found_in_trash' => _x( 'هیچ بلوکی در سطل زباله یافت نمی شود', 'foodking-toolkit' ),
	'parent_item_colon'  => '',
	'menu_name'          => _x( 'بلوک های فودکینگ', 'foodking-toolkit' )
);

$args = array(
	'labels'             => $labels,
	'public'             => true,
	'publicly_queryable' => true,
	'exclude_from_search'=> true,
	'show_ui'            => true,
	'show_in_menu'       => true,
	'show_in_nav_menus'  => false,
	'query_var'          => true,
	'rewrite'            => array( 'slug' => 'foodking_blocks' ),
	'capability_type'    => 'post',
	'has_archive'        => false,
	'hierarchical'       => false,
	'menu_position'      => null,
	'menu_icon'          => 'dashicons-clipboard',
	'supports'           => array( 'title', 'editor')
);

register_post_type( 'foodking_blocks', $args );

//add Foodking Blocks shortcode to post list view
add_filter('manage_foodking_blocks_posts_columns', 'rcb_columns_head_foodking_blocks', 10);
add_action('manage_foodking_blocks_posts_custom_column', 'rcb_columns_content_foodking_blocks', 10, 2);
 
//re arrange post list columns order and add new
function rcb_columns_head_foodking_blocks($defaults) {
	$new = array();
	foreach($defaults as $key => $title) {
    if ($key=='date') // Put the Thumbnail column before the Author column
		$new['rcb_shortcode'] = esc_html__( 'استفاده', 'foodking-toolkit' );
		$new[$key] = $title;
	}
	
    return $new;
}
function rcb_columns_content_foodking_blocks($column_name, $post_ID) {
    if ($column_name == 'rcb_shortcode') {
		echo rcb_get_usage_codes( $post_ID, $width = false );
    }
}

//add Foodking Blocks shortcode to Publish metabox
add_action('post_submitbox_misc_actions', 'add_tcpshortcode_to_publish_meta_box');
function add_tcpshortcode_to_publish_meta_box($post_obj) {
 
  global $post;
  $post_type = 'foodking_blocks'; 
  $pid = $post_obj->ID;
  
  if($post_type==$post->post_type) {

    echo "<div class='misc-pub-section misc-pub-section-last'>";
    echo rcb_get_usage_codes( $pid, $width = true );
    echo "</div>";
	
  }
}

function rcb_get_usage_codes( $pid, $width ) {

	$shortocde = '[foodking_block id="'.$pid.'"]';
	$function = '<?php foodking_block_by_id( "'.$pid.'" ); ?>';
	
	$class = ($width ) ? "class='widefat'" : "style='width:230px'";
	
	$codes = esc_html( 'کد کوتاه:', 'foodking-toolkit' )." <input type='text' value='".$shortocde."'".$class." readonly></br>";
	$codes .= esc_html( 'تابع: &nbsp;', 'foodking-toolkit' )." <input type='text' value='".$function."'".$class." readonly>";
	
	return $codes;
}
?>