<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package foodking
 */

global $foodking_opt;

$error_page_title		= isset($foodking_opt['error_page_title']) ? $foodking_opt['error_page_title'] : '';
$error_page_desc		= isset($foodking_opt['error_page_desc']) ? $foodking_opt['error_page_desc'] : '';
$error_page_action_url	= isset($foodking_opt['error_page_action_url']) ? $foodking_opt['error_page_action_url'] : '';

include get_template_directory() . '/inc/blog-header.php';
get_header();
?>
	<?php if ($error_page_title): ?>
		<!-- 404 Error Section Start -->
		<section class="error-section section-bg section-padding fix">
			<div class="container">
				<div class="error-content text-center">
					<h2 class="wow fadeInUp" data-wow-delay=".3s"><?php echo esc_html($error_page_title); ?></h2>
					<h3 class="wow fadeInUp" data-wow-delay=".5s"><?php echo esc_html($error_page_desc); ?></h3>
					<?php if($error_page_action_url): ?>
						<a href="<?php echo esc_url( home_url( '/' ) );?>" class="theme-btn style-line-height mt-5 wow fadeInUp" data-wow-delay=".7s">
						<span class="button-text"><?php echo esc_html($error_page_action_url); ?></span>
						</a>
					<?php endif; ?>
				</div>
			</div>
		</section>
	<?php else: ?>
		<div class="error__wrapper">
			<div class="error__text">
				<h1><?php esc_html_e('404', 'foodking'); ?></h1>
				<h2><?php esc_html_e('404 Error : Page Not Found', 'foodking'); ?></h2>
				<p><?php esc_html_e('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'foodking'); ?></p>
			</div>
			<div class="error__btn">
				<a href="<?php echo esc_url( home_url( '/' ) );?>" class="main-btn"><?php esc_html_e('Back To Home', 'foodking'); ?></a>
			</div>
		</div>
	<?php endif; ?>

	<?php if($cta_banner_bg): ?>
		<!-- Main Cta Banner Section Start -->
		<section class="main-cta-banner-2 section-padding bg-cover" style="background-image: url(<?php echo esc_url($cta_banner_bg); ?>)">
			<div class="tomato-shape-left float-bob-y">
				<?php if($cta_shape_img_1):?>
					<img src="<?php echo esc_url($cta_shape_img_1);?>" alt="<?php esc_attr_e('shape-img','foodking');?>">
				<?php endif;?>
			</div>
			<div class="chili-shape-right float-bob-y">
				<?php if($cta_shape_img_2):?>
					<img src="<?php echo esc_url($cta_shape_img_2);?>" alt="<?php esc_attr_e('shape-img','foodking');?>">
				<?php endif;?>
			</div>
			<div class="container">
				<div class="main-cta-banner-wrapper-2 d-flex align-items-center justify-content-between">
					<div class="section-title mb-0">
						<span class="theme-color-3"><?php echo esc_html($cta_subtitle);?></span>
						<h2 class="text-white">
						<?php echo esc_html($cta_title_1);?> <br>
							<span class="theme-color-3"><?php echo esc_html($cta_title_2);?></span> <?php echo esc_html($cta_title_3);?>
						</h2>
					</div>
					<?php if($cta_btn): ?>
						<a href="<?php echo esc_url($cta_btn_link); ?>" class="theme-btn bg-white">
						<span class="button-content-wrapper d-flex align-items-center">
						<span class="button-icon"><i class="fas fa-shipping-fast"></i></span>
						<span class="button-text"><?php echo esc_html($cta_btn); ?></span>
						</span>
						</a>
					<?php endif;?>
					<div class="delivery-man">
						<?php if($cta_sec_img):?>
							<img src="<?php echo esc_url($cta_sec_img);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
						<?php endif;?>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>

<?php
get_footer();
