/* ===================================================================
    Author          : Modina Theme
    Version         : 1.1
* ================================================================= */

(function($) {
    "use strict";

    $(document).ready( function() {

        //>> Sidebar Toggle Js Start <<//
        $(".offcanvas__close,.offcanvas__overlay").on("click", function() {
            $(".offcanvas__info").removeClass("info-open");
            $(".offcanvas__overlay").removeClass("overlay-open");
        });
        $(".sidebar__toggle").on("click", function() {
            $(".offcanvas__info").addClass("info-open");
            $(".offcanvas__overlay").addClass("overlay-open");
        });

        //>> Body Overlay Js Start <<//
        $(".body-overlay").on("click", function() {
            $(".offcanvas__area").removeClass("offcanvas-opened");
            $(".df-search-area").removeClass("opened");;
            $(".body-overlay").removeClass("opened");
        });

        //>>  Product Plus Minus <<//
        $(".plus-btn").on('click', function() {
            var  input = $(this).prev('input.qty');
            var val = parseInt(input.val());
            var step = input.attr('step');
            step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
            input.val( val + step ).change();
        });

        $(".minus-btn").on('click', function() {
            var input = $(this).next('input.qty');
            var val = parseInt(input.val());
            var step = input.attr('step');
            step = 'undefined' !== typeof(step) ? parseInt(step) : 1;
            if (val > 0) {
                input.val( val - step ).change();
            }
        });

        //>> Scroll Js Start <<//
        const scrollPath = document.querySelector(".scroll-up path");
        const pathLength = scrollPath.getTotalLength();
        scrollPath.style.transition = scrollPath.style.WebkitTransition = "none";
        scrollPath.style.strokeDasharray = pathLength + " " + pathLength;
        scrollPath.style.strokeDashoffset = pathLength;
        scrollPath.getBoundingClientRect();
        scrollPath.style.transition = scrollPath.style.WebkitTransition = "stroke-dashoffset 10ms linear";

        const updatescroll = function() {
            let scrolltotal = $(window).scrollTop();
            let height = $(document).height() - $(window).height();
            let scrolltotalheight = pathLength - (scrolltotal * pathLength) / height;
            scrollPath.style.strokeDashoffset = scrolltotalheight;
        };
        updatescroll();

        $(window).scroll(updatescroll);
        const offset = 50;
        const duration = 950;

        $(window).on("scroll", function() {
            if (jQuery(this).scrollTop() > offset) {
                jQuery(".scroll-up").addClass("active-scroll");
            } else {
                jQuery(".scroll-up").removeClass("active-scroll");
            }
        });

        $(".scroll-up").on("click", function(event) {
            event.preventDefault();
            jQuery("html, body").animate({
                    scrollTop: 0,
                },
                duration
            );
            return false;
        });

        //>> Search Popup Start <<//
        const $searchWrap = $(".search-wrap");
        const $navSearch = $(".nav-search");
        const $searchClose = $("#search-close");

        $(".search-trigger").on("click", function (e) {
            e.preventDefault();
            $searchWrap.animate({ opacity: "toggle" }, 500);
            $navSearch.add($searchClose).addClass("open");
        });

        $(".search-close").on("click", function (e) {
            e.preventDefault();
            $searchWrap.animate({ opacity: "toggle" }, 500);
            $navSearch.add($searchClose).removeClass("open");
        });

        function closeSearch() {
            $searchWrap.fadeOut(200);
            $navSearch.add($searchClose).removeClass("open");
        }

        $(document.body).on("click", function (e) {
            closeSearch();
        });

        $(".search-trigger, .main-search-input").on("click", function (e) {
            e.stopPropagation();
        });

        //>> Scroll Up Start <<//
        $("#scrollUp").on("click", function () {
            setTimeout(function () {
                $("html, body").animate({ scrollTop: "-=1000000px" }, "slow");
            }, 1000);
        });

        //>> Quantity Js Start <<//
        $(".quantity").on("click", ".plus", function (e) {
            let $input = $(this).prev("input.qty");
            let val = parseInt($input.val(), 10); // Specify base 10
            $input.val(val + 1).change();
        });

        $(".quantity").on("click", ".minus", function (e) {
            let $input = $(this).next("input.qty");
            const val = parseInt($input.val(), 10); // Specify base 10
            if (val > 0) {
                $input.val(val - 1).change();
            }
        });

        //>> Quantity Cart Js Start <<//
        let quantity = 0;
        let price = 0;
        $(".cart-item-quantity-amount, .product-quant").html(quantity);
        $(".total-price, .product-pri").html(price.toFixed(2));
        $(".cart-increment, .cart-incre").on("click", function() {
            if (quantity <= 4) {
                quantity++;
                $(".cart-item-quantity-amount, .product-quant").html(quantity);
                let basePrice = $(".base-price, .base-pri").text();
                $(".total-price, .product-pri").html((basePrice * quantity).toFixed(2));
            }
        });

        $(".cart-decrement, .cart-decre").on("click", function() {
            if (quantity >= 1) {
                quantity--;
                $(".cart-item-quantity-amount, .product-quant").html(quantity);
                let basePrice = $(".base-price, .base-pri").text();
                $(".total-price, .product-pri").html((basePrice * quantity).toFixed(2));
            }
        });

        $(".cart-item-remove>a").on("click", function() {
            $(this).closest(".cart-item").hide(300);
        });

        //>> PaymentMethod Js Start <<//
        let paymentMethod = $("input[name='pay-method']:checked").val();
        $(".payment").html(paymentMethod);
        $(".checkout-radio-single").on("click", function() {
            let paymentMethod = $("input[name='pay-method']:checked").val();
            $(".payment").html(paymentMethod);
        });

        if($('.testimonial-section .fry-shape').length > 0) {
            const testimonialSection = gsap.timeline({
                scrollTrigger: {
                trigger: ".testimonial-section",
                scrub: 1,
                start: 'top 70%',
                end: 'top 10%',
                }
            });
            testimonialSection.to(".testimonial-section .fry-shape", {yPercent: 100, ease: "none"});
            testimonialSection.to(".testimonial-section .pizza-shape", {rotation: 360, duration: 3});
            testimonialSection.to(".testimonial-section .burger-shape", {rotation: 270, duration: 3});
        }

        if($('.food-category-section .burger-shape-2').length > 0) {
            const categoryFood = gsap.timeline({
                scrollTrigger: {
                trigger: ".food-category-section",
                scrub: 1,
                start: 'top 50%',
                end: 'top 10%',
                }
            });
            categoryFood.to(".food-category-section .tomato-shape", {yPercent: -40, ease: "none"});
            categoryFood.to(".food-category-section .burger-shape-2", {xPercent: 100, ease: "none"});
        }

        if($('.main-cta-banner').length > 0) {
            const bike = gsap.timeline({
                scrollTrigger: {
                trigger: ".main-cta-banner",
                scrub: 1,
                end: "+=1000",
                }
            });
            bike.to(".delivery-man", {xPercent: -20, ease: "none",});
        }

        if($('.main-cta-banner-2').length > 0) {
            const bike2 = gsap.timeline({
                scrollTrigger: {
                trigger: ".main-cta-banner-2",
                scrub: 1,
                end: "+=1000",
                }
            });
            bike2.to(".delivery-man", {xPercent: -20, ease: "none",});
        }

        if($('.news-section .burger-shape').length > 0) {
            const newsShape = gsap.timeline({
                scrollTrigger: {
                trigger: ".news-section",
                scrub: 1,
                end: "+=1000",
                }
            });
            newsShape.to(".news-section .burger-shape", {yPercent: 130, ease: "none",})
            newsShape.to(".news-section .fry-shape", {rotation: 350, ease: "none",});
        }

        if($('.footer-section .burger-shape').length > 0) {
            const footerShape = gsap.timeline({
                scrollTrigger: {
                trigger: ".footer-section",
                scrub: 1,
                end: "+=1000",
                }
            });
    
            footerShape.to(".burger-shape", {yPercent: -200, ease: "none",})
            footerShape.to(".fry-shape", {xPercent: 350, ease: "none",});
        }

        if($('.footer-section .footer-shape').length > 0) {
            const footerShape = gsap.timeline({
                scrollTrigger: {
                trigger: ".footer-section",
                scrub: 1,
                end: "+=1000",
                }
            });
    
            footerShape.to(".footer-shape", {yPercent: -100, ease: "none",})
            footerShape.to(".footer-shape-2", {rotation: 360, ease: "none",});
        }

        $('.navbar-nav li.menu-item-has-children>a').on('click', function(){
            $(this).removeAttr('href');
            var element = $(this).parent('li');
            if (element.hasClass('open')) {
                element.removeClass('open');
                element.find('li').removeClass('open');
                element.find('ul').slideUp();
            }
            else {
                element.addClass('open');
                element.children('ul').slideDown();
                element.siblings('li').children('ul').slideUp();
                element.siblings('li').removeClass('open');
                element.siblings('li').find('li').removeClass('open');
                element.siblings('li').find('ul').slideUp();
            }
        });
    
        $('.navbar-nav>ul>li.menu-item-has-children>a').append('<span class="holder"></span>');
    
        function rgbToHsl(r, g, b) {
            r /= 255, g /= 255, b /= 255;
            var max = Math.max(r, g, b), min = Math.min(r, g, b);
            var h, s, l = (max + min) / 2;
    
            if(max == min){
                h = s = 0;
            }
            else {
                var d = max - min;
                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
                switch(max){
                    case r: h = (g - b) / d + (g < b ? 6 : 0); break;
                    case g: h = (b - r) / d + 2; break;
                    case b: h = (r - g) / d + 4; break;
                }
                h /= 6;
            }
            return l;
        }

    }); // End Document Ready Function

    $(window).on('load', function() {
        // Animate loader off screen
        $(".preloader").addClass('loaded');                    
        $(".preloader").delay(700).fadeOut();  
    });

    // Start Elementor JS Support
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/global', function( $scope ) {
            //>> Hero Slider Start <<//
            const sliderActive1 = ".hero-slider";
            const sliderInit1 = new Swiper(sliderActive1, {
                loop: true,
                slidesPerView: 1,
                effect: "fade",
                speed: 2000,
                autoplay: {
                delay: 5000,
                disableOnInteraction: false,
                },
                pagination: {
                    el: ".dot",
                    clickable: true,
                },
                
            });
            // content animation when active start here
            function animated_swiper(selector, init) {
                let animated = function animated() {
                    $(selector + " [data-animation]").each(function () {
                        let anim = $(this).data("animation");
                        let delay = $(this).data("delay");
                        let duration = $(this).data("duration");
                        $(this)
                            .removeClass("anim" + anim)
                            .addClass(anim + " animated")
                            .css({
                                webkitAnimationDelay: delay,
                                animationDelay: delay,
                                webkitAnimationDuration: duration,
                                animationDuration: duration,
                            })
                            .one("animationend", function () {
                                $(this).removeClass(anim + " animated");
                            });
                    });
                };
                animated();
                init.on("slideChange", function () {
                    $(sliderActive1 + " [data-animation]").removeClass("animated");
                });
                init.on("slideChange", animated);
            }
            animated_swiper(sliderActive1, sliderInit1);
            //>> Hero Slider End <<//

            //>> Hero Slider Start <<//
            const sliderActive2 = ".hero-slider-2";
            const sliderInit2 = new Swiper(sliderActive2, {
                loop: true,
                slidesPerView: 1,
                effect: "fade",
                speed: 2000,
                autoplay: {
                delay: 5000,
                disableOnInteraction: false,
                },
                pagination: {
                    el: ".pegi-number",
                    type: "fraction",
                },
                
            });
            // content animation when active start here
            function animated_swiper(selector, init) {
                let animated = function animated() {
                    $(selector + " [data-animation]").each(function () {
                        let anim = $(this).data("animation");
                        let delay = $(this).data("delay");
                        let duration = $(this).data("duration");
                        $(this)
                            .removeClass("anim" + anim)
                            .addClass(anim + " animated")
                            .css({
                                webkitAnimationDelay: delay,
                                animationDelay: delay,
                                webkitAnimationDuration: duration,
                                animationDuration: duration,
                            })
                            .one("animationend", function () {
                                $(this).removeClass(anim + " animated");
                            });
                    });
                };
                animated();
                init.on("slideChange", function () {
                    $(sliderActive1 + " [data-animation]").removeClass("animated");
                });
                init.on("slideChange", animated);
            }
            animated_swiper(sliderActive2, sliderInit2);
            //>> Hero Slider End <<//

            //>> Video Popup Start <<//
            $(".img-popup").magnificPopup({
                type: "image",
                gallery: {
                    enabled: true,
                },
            });

            $('.video-popup').magnificPopup({
                type: 'iframe',
                callbacks: {
                }
            });
            
            //>> Counterup Start <<//
            $(".count").counterUp({
                delay: 15,
                time: 4000,
            });

            //>> Wow Animation Start <<//
            new WOW().init();

            //>> Nice Select Start <<//
            $('select').niceSelect();

            //>> Active Js Start <<//
            $(".contact-info-items").hover(
                function() {
                    $(".contact-info-items").removeClass("active");
                    $(this).addClass("active");
                }
            );

            //>> Food Catagory Slider Start <<//
            const foodCatagorySlider = new Swiper(".food-catagory-slider", {
                spaceBetween: 30,
                speed: 800,
                loop: false,
                autoplay: {
                    delay: 3000,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
                breakpoints: {
                    1399: {
                        slidesPerView: 4,
                    },
                    1199: {
                        slidesPerView: 3,
                    },
                    991: {
                        slidesPerView: 3,
                    },
                    767: {
                        slidesPerView: 2,
                    },
                    575: {
                        slidesPerView: 1,
                    },
                    0: {
                        slidesPerView: 1,
                    },
                },
            });


            //>> Food Catagory Slider Start <<//
            const brandSlider = new Swiper(".brand-slider", {
                spaceBetween: 30,
                speed: 1000,
                loop: "true",
                speed: 1000,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
                breakpoints: {
                    1399: {
                        slidesPerView: 6,
                    },
                    991: {
                        slidesPerView: 5,
                    },
                    768: {
                        slidesPerView: 4,
                    },
                    500: {
                        slidesPerView: 3,
                    },
                    400: {
                        slidesPerView: 2,
                    },
                },
            });

            //>> Testimonial Slider Start <<//
            var swiper = new Swiper(".testimonial-content-slider", {
                loop: true,
                spaceBetween: 10,
                freeMode: true,
                watchSlidesProgress: true,
                centeredSlides: true,
                autoplay: {
                    delay: 4500,
                    disableOnInteraction: false
                },
            });

            var swiper2 = new Swiper(".testimonial-image-slider", {
                loop: true,
                spaceBetween: 20,
                centeredSlides: true,
                autoplay: {
                    delay: 4500,
                    disableOnInteraction: false
                },
                breakpoints: {
                    0: {
                        slidesPerView: 1
                    },
                    768: {
                        slidesPerView: 3,
                    },
                    992: {
                        slidesPerView: 3
                    },
                    1200: {
                        slidesPerView: 3,
                    },
                },
                thumbs: {
                    swiper: swiper,
                },
            });

            const testimonialContentSlider2 = new Swiper(".testimonial-content-slider-2", {
                spaceBetween: 30,
                speed: 1000,
                loop: "true",
                slidesPerView: 1,
                speed: 2000,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: ".dot-2",
                    clickable: true,
                },
            
            });

            const testimonialContentSlider3 = new Swiper(".testimonial-content-slider-3", {
                spaceBetween: 30,
                speed: 1000,
                loop: "true",
                slidesPerView: 1,
                speed: 2000,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                pagination: {
                    el: ".dot-2",
                    clickable: true,
                },
            
            });

            //>> Food Catagory Slider Start <<//
            const gallerySlider = new Swiper(".gallery-slider", {
                spaceBetween: 30,
                loop: "true",
                speed: 2000,
                //centeredSlides: true,
                autoplay: {
                    delay: 2000,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
                breakpoints: {
                    1199: {
                        slidesPerView: 3,
                    },
                    991: {
                        slidesPerView: 3,
                    },
                    768: {
                        slidesPerView: 3,
                    },
                    485: {
                        slidesPerView: 2,
                    },
                    0: {
                        slidesPerView: 1,
                    },
                },
            });

            //>> Food Catagory Slider Start <<//
            const todayBestSaleImageSlider = new Swiper(".today-best-sale-image-slider", {
                loop: "true",
                speed: 3000,
                autoplay: {
                    delay: 3000,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
                breakpoints: {
                    991: {
                        slidesPerView: 1,
                    },
                },
            });

            //>> Food Catagory Slider Start <<//
            const instagramBannerSlider = new Swiper(".instagram-banner-slider", {
                spaceBetween: 0,
                loop: "true",
                speed: 2000,
                autoplay: {
                    delay: 1500,
                    disableOnInteraction: false,
                },
                navigation: {
                    nextEl: ".array-prev",
                    prevEl: ".array-next",
                },
                breakpoints: {
                    1299: {
                        slidesPerView: 5,
                    },
                    1199: {
                        slidesPerView: 4,
                    },
                    991: {
                        slidesPerView: 3,
                    },
                    768: {
                        slidesPerView: 2,
                    },
                    575: {
                        slidesPerView: 1,
                    },
                    0: {
                        slidesPerView: 1,
                    },
                },
            });

        });
    });
    //End Elementor JS Support
    document.addEventListener('DOMContentLoaded', function() {
        var selectField = document.querySelector('select[name="select-person"]');
        if (selectField) {
            selectField.options[0].text = "لطفاً یک گزینه را انتخاب کنید";
        }
    });


})(jQuery); // End jQuery