<?php
/**
 * Social Link
 *
 * @package WordPress
 * @subpackage foodking
 */
if ( ! function_exists( 'foodking_social_link' ) ) :
    function foodking_social_link() {
        $social_links = [
            'facebook'  => 'fab fa-facebook-f',
            'twitter'   => 'fab fa-twitter',
            'instagram' => 'fab fa-instagram',
            'linkedin'  => 'fab fa-linkedin-in',
            'pinterest' => 'fab fa-pinterest-p',
            'dribbble'  => 'fab fa-dribbble',
            'tumblr'    => 'fab fa-tumblr',
            'youtube'   => 'fab fa-youtube',
            'flickr'    => 'fab fa-flickr',
            'behance'   => 'fab fa-behance',
            'github'    => 'fab fa-github',
            'skype'     => 'fab fa-skype',
            'rss'       => 'fab fa-rss',
            'tiktok'    => 'fab fa-tiktok',
            'google'    => 'fab fa-google',
            'medium'    => 'fab fa-medium-m',
            'snapchat'  => 'fab fa-snapchat',
            'vimeo'     => 'fab fa-vimeo-v',
            'wechat'    => 'fab fa-weixin',
            'whatsapp'  => 'fab fa-whatsapp',
            'telegram'  => 'fab fa-telegram-plane',
        ];
        global $foodking_opt;
        $target = isset( $foodking_opt['foodking_social_target'] ) ? $foodking_opt['foodking_social_target'] : '_blank';
        foreach ( $social_links as $key => $value ) {
            if ( isset( $foodking_opt[ $key . '_url' ] ) && $foodking_opt[ $key . '_url' ] ) {
                printf(
                    '<li><a class="%s" target="%s" href="%s"><i class="%s"></i></a></li>',
                    esc_attr( $key ),
                    esc_attr( $target ),
                    esc_url( $foodking_opt[ $key . '_url' ] ),
                    esc_attr( $value )
                );
            }
        }
    }
endif;