<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package foodking
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function foodking_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'foodking-sidebar' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'foodking_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function foodking_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'foodking_pingback_header' );

/**
 * Kulan Allowed HTML
 */
if ( ! function_exists( 'foodking_kses_allowed_html' ) ) {
	function foodking_kses_allowed_html($tags, $context) {
		$allowed_atts = array(
			'align'      => array(),
			'class'      => array(),
			'type'       => array(),
			'id'         => array(),
			'dir'        => array(),
			'lang'       => array(),
			'style'      => array(),
			'xml:lang'   => array(),
			'src'        => array(),
			'alt'        => array(),
			'href'       => array(),
			'rel'        => array(),
			'rev'        => array(),
			'target'     => array(),
			'novalidate' => array(),
			'type'       => array(),
			'value'      => array(),
			'name'       => array(),
			'tabindex'   => array(),
			'action'     => array(),
			'method'     => array(),
			'for'        => array(),
			'width'      => array(),
			'height'     => array(),
			'data'       => array(),
			'title'      => array(),
		);
		switch($context) {
		case 'foodkingallowedhtml':
			$tags = array(
				'form'    => $allowed_atts,
				'label'   => $allowed_atts,
				'input'   => $allowed_atts,
				'textarea'=> $allowed_atts,
				'iframe'  => $allowed_atts,
				'script'  => $allowed_atts,
				'style'   => $allowed_atts,
				'strong'  => $allowed_atts,
				'small'   => $allowed_atts,
				'table'   => $allowed_atts,
				'span'    => $allowed_atts,
				'abbr'    => $allowed_atts,
				'code'    => $allowed_atts,
				'pre'     => $allowed_atts,
				'div'     => $allowed_atts,
				'img'     => $allowed_atts,
				'h1'      => $allowed_atts,
				'h2'      => $allowed_atts,
				'h3'      => $allowed_atts,
				'h4'      => $allowed_atts,
				'h5'      => $allowed_atts,
				'h6'      => $allowed_atts,
				'ol'      => $allowed_atts,
				'ul'      => $allowed_atts,
				'li'      => $allowed_atts,
				'em'      => $allowed_atts,
				'hr'      => $allowed_atts,
				'br'      => $allowed_atts,
				'tr'      => $allowed_atts,
				'td'      => $allowed_atts,
				'p'       => $allowed_atts,
				'a'       => $allowed_atts,
				'b'       => $allowed_atts,
				'i'       => $allowed_atts,
			);
			return $tags;
		default:
			return $tags;
		}
	}
}
add_filter( 'wp_kses_allowed_html', 'foodking_kses_allowed_html', 10, 2);

/**
 * Insoand Preloader
*/

if ( ! function_exists( 'foodking_preloader' ) ) :
	function foodking_preloader() {
		global $foodking_opt;
		$is_preloader	= !empty($foodking_opt['enable_preloader']) ? $foodking_opt['enable_preloader'] : '';
		$loading_text2	= !empty($foodking_opt['loading_text2']) ? $foodking_opt['loading_text2'] : '';
        
		if( $is_preloader == true ):
			if (!empty( $foodking_opt['loading_text'] ) ) : 
				$loading_texts = $foodking_opt['loading_text'];
				$loading_texts = explode(',', $loading_texts);
				?>
				<div id="preloader" class="preloader">
					<div class="animation-preloader">
						<div class="spinner">                
						</div>
						<div class="txt-loading">
							<?php foreach($loading_texts as $text): ?>
								<span data-text-preloader="<?php echo esc_attr($text); ?>" class="letters-loading">
								<?php echo esc_html($text); ?>
							</span>
							<?php endforeach; ?>
						</div>

						<?php if($loading_text2): ?>
							<p class="text-center"><?php echo esc_html($loading_text2); ?></p>
						<?php endif; ?>
					</div>
					<div class="loader">
						<div class="row">
							<div class="col-3 loader-section section-left">
								<div class="bg"></div>
							</div>
							<div class="col-3 loader-section section-left">
								<div class="bg"></div>
							</div>
							<div class="col-3 loader-section section-right">
								<div class="bg"></div>
							</div>
							<div class="col-3 loader-section section-right">
								<div class="bg"></div>
							</div>
						</div>
					</div>
				</div>
				<?php 
			endif;
        endif;
	}
endif;


if ( ! function_exists( 'foodking_post_pagination' ) ) {
	function foodking_post_pagination(){
		?>
		<div class="custom__pagination w-100 d-flex justify-content-center"> 
			<ul> 
				<?php 
				echo paginate_links( array(
					'format'        => '?paged=%#%',
					'prev_text'     => '<i class="fa fa-chevron-left" aria-hidden="true"></i>',
					'end_size'      => 0,
					'mid_size'      => 1,
					'next_text'     => '<i class="fa fa-chevron-right" aria-hidden="true"></i>',
					)
				); 
				?>
			</ul>
		</div> 
		<?php
    }
}
