<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package foodking
 */

get_header();

include get_template_directory() . '/inc/blog-header.php';
?>

	<!--<< Breadcrumb Section Start >>-->
	<div class="breadcrumb-wrapper bg-cover <?php if(!$blog_header_banner): ?>no-image<?php endif; ?>" <?php if($blog_header_banner): ?> style="background-image: url(<?php echo esc_url($blog_header_banner); ?>)"<?php endif; ?>>
		<div class="container">
			<div class="page-heading center">
				<h1><?php echo esc_html($blog_page_title); ?></h1>
				<ul class="breadcrumb-items">
					<?php foodking_breadcrumb_trail(); ?>
				</ul>
			</div>
		</div>
	</div>

	<!--<< Blog Wrapper Here >>-->
	<section class="blog-wrapper news-wrapper section-padding section-bg">
		<div class="<?php echo esc_attr($foodking_blog_layout); ?>">
			<div class="news-area">
				<div class="row">

					<!--Left Sidebar Layout-->
					<?php if( $sidebar_hide == 'foodking_with_sidebar' ): ?>
						<?php if($foodking_blog_sidebar_position == 'left'): ?>
							<div class="col-12 col-lg-4">
								<?php get_sidebar(); ?>
							</div>
						<?php endif; ?>
					<?php endif; ?>

					<div class="<?php echo esc_attr($foodking_sidebar_class); ?>">
						<div class="blog-posts">
							<div class="<?php echo esc_attr( $foodking_blog_grid ); ?>">
								<?php
								if ( have_posts() ) :
									while ( have_posts() ) : the_post();
										get_template_part( 'template-parts/content', get_post_format());
									endwhile;
								else :
									get_template_part( 'template-parts/content', 'none' );
								endif;
								?>
							</div>
						</div>
						<div class="page-nav-wrap mt-5 text-center">
							<ul>
								<?php echo paginate_links( array(
									'format'        => '?paged=%#%',
									'prev_text'     => "<i class='fas fa-long-arrow-alt-left'></i>",
									'end_size'      => 0,
									'mid_size'      => 1,
									'next_text'     => "<i class='fas fa-long-arrow-alt-right'></i>",
										)
								); ?>
							</ul>
						</div>
					</div>
					<!--Right Sidebar Layout-->
					<?php if( $sidebar_hide == 'foodking_with_sidebar' ): ?>
						<?php if($foodking_blog_sidebar_position == 'right'): ?>
							<div class="col-12 col-lg-4">
								<?php get_sidebar(); ?>
							</div>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</section>

	<?php if($cta_banner_bg): ?>
		<!-- Main Cta Banner Section Start -->
		<section class="main-cta-banner-2 section-padding bg-cover" style="background-image: url(<?php echo esc_url($cta_banner_bg); ?>)">
			<div class="tomato-shape-left float-bob-y">
				<?php if($cta_shape_img_1):?>
					<img src="<?php echo esc_url($cta_shape_img_1);?>" alt="<?php esc_attr_e('shape-img','foodking');?>">
				<?php endif;?>
			</div>
			<div class="chili-shape-right float-bob-y">
				<?php if($cta_shape_img_2):?>
					<img src="<?php echo esc_url($cta_shape_img_2);?>" alt="<?php esc_attr_e('shape-img','foodking');?>">
				<?php endif;?>
			</div>
			<div class="container">
				<div class="main-cta-banner-wrapper-2 d-flex align-items-center justify-content-between">
					<div class="section-title mb-0">
						<span class="theme-color-3"><?php echo esc_html($cta_subtitle);?></span>
						<h2 class="text-white">
						<?php echo esc_html($cta_title_1);?> <br>
							<span class="theme-color-3"><?php echo esc_html($cta_title_2);?></span> <?php echo esc_html($cta_title_3);?>
						</h2>
					</div>
					<?php if($cta_btn): ?>
						<a href="<?php echo esc_url($cta_btn_link); ?>" class="theme-btn bg-white">
						<span class="button-content-wrapper d-flex align-items-center">
						<span class="button-icon"><i class="fas fa-shipping-fast"></i></span>
						<span class="button-text"><?php echo esc_html($cta_btn); ?></span>
						</span>
						</a>
					<?php endif;?>
					<div class="delivery-man">
						<?php if($cta_sec_img):?>
							<img src="<?php echo esc_url($cta_sec_img);?>" alt="<?php esc_attr_e('Foodking - Fast Food Restaurant WordPress Theme','foodking');?>">
						<?php endif;?>
					</div>
				</div>
			</div>
		</section>
	<?php endif; ?>

<?php
get_footer();
