<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'foodking_register_required_plugins' );

if ( ! function_exists( 'foodking_register_required_plugins' ) ) {
	function foodking_register_required_plugins() {

		$plugins = array(
			array(
				'name'      => esc_html__('ابزار فودکینگ', 'foodking'),
				'slug'      => 'foodking-toolkit',
				'source'    => get_stylesheet_directory() . '/lib/plugins/foodking-toolkit.zip',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('صفحه ساز المنتور ', 'foodking'),
				'slug'      => 'elementor',
				'required'  => false,
			),

            array(
                'name'      => esc_html__('شمسی ساز تقویم ', 'foodking'),
                'slug'      => 'persian-date',
                'required'  => false,
            ),
			array(
				'name'      => esc_html__('فیلد پیشرفته', 'foodking'),
				'slug'      => 'advanced-custom-fields',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('فرم تماس هفت ', 'foodking'),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),
			array(
				'name'		=> esc_html__( 'درون ریز دمو', 'foodking' ),
				'slug'      => 'one-click-demo-import',
				'required'  => false,
			),
			// WooCommerce
			array(
				'name'      => esc_html__('ووکامرس', 'foodking'),
				'slug'      => 'woocommerce',
				'required'  => false,
			),

			// YITH WooCommerce Wishlist
			array(
				'name'      => esc_html__('علاقه مندی ووکامرس', 'foodking'),
				'slug'      => 'yith-woocommerce-wishlist',
				'required'  => false,
			),
		);

		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true,
			'dismissable'  => true,
			'dismiss_msg'  => '',
			'is_automatic' => false,
			'message'      => '',
		);
		tgmpa( $plugins, $config );
	}
}