<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package foodking
 */

get_header();

if ( class_exists('ACF') ) {
	$hide_page_banner	= get_field('hide_page_banner');
	$banner_image 		= get_field('banner_image');
	$banner_title 		= get_field('banner_title');
}else{
	$hide_page_banner = $banner_image = $banner_title = '';
}

if( !$banner_title){
$banner_title = get_the_title();
}

if($hide_page_banner == false) :
	?>

	<!--<< Breadcrumb Section Start >>-->
	<div class="breadcrumb-wrapper bg-cover <?php if(!$banner_image): ?>no-image<?php endif; ?>" <?php if($banner_image): ?> style="background-image: url(<?php echo esc_url($banner_image); ?>)"<?php endif; ?>>
		<div class="container">
			<div class="page-heading center">
				<h1><?php echo esc_html($banner_title); ?></h1>
				<ul class="breadcrumb-items">
					<?php foodking_breadcrumb_trail(); ?>
				</ul>
			</div>
		</div>
	</div>
	<?php 
endif; ?>

<?php if( !foodking_is_elementor()): ?><div class="page-main-content"><?php endif; ?>
	<div class="page-area">
		<?php if( !foodking_is_elementor()): ?><div class="container"><?php endif; ?>
			<?php while ( have_posts() ) : the_post(); ?>
				<?php $thecontent = get_the_content(); // If no content ?>
				<?php if(empty($thecontent)){ ?> <div class="foodking-single-blank-page"></div><?php } ?>
				<?php get_template_part( 'template-parts/content', 'page' ); ?>
				<?php if ( comments_open() || get_comments_number() ) : comments_template(); endif; // If comments are open or we have at least one comment, load up the comment template. ?>
			<?php endwhile; // End of the loop. ?>
		<?php if( !foodking_is_elementor()): ?></div><?php endif; ?>
	</div>
<?php if( !foodking_is_elementor()): ?></div><?php endif; ?>

<?php
get_footer();
