<?php
/**
 * The template for displaying single team
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package foodking
 */

get_header();

if ( class_exists('ACF') ) {
$hide_page_banner 		= get_field('hide_page_banner');
$banner_title 			= get_field('banner_title');
$banner_image 			= get_field('banner_image');
}else{
$hide_page_banner =  $banner_title = $banner_image = '';
}

if( !$banner_title){
$banner_title = get_the_title();
}
    if($hide_page_banner == false):
        ?>
        <!--<< Breadcrumb Section Start >>-->
        <div class="breadcrumb-wrapper bg-cover <?php if(!$single_blog_header_banner): ?>no-image<?php endif; ?>" <?php if($banner_image): ?> style="background-image: url(<?php echo esc_url($banner_image); ?>)"<?php endif; ?>>
            <div class="container">
                <div class="page-heading center">
                    <h1><?php echo esc_html($banner_title); ?></h1>
                    <ul class="breadcrumb-items">
                        <?php foodking_breadcrumb_trail(); ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif;?>

    <?php the_content();?>
<?php
get_footer();