<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package foodking
 */
global $foodking_opt;

$read_more	= isset($foodking_opt['read_more']) ? $foodking_opt['read_more'] : 'Read More';
$author_link = get_author_posts_url(get_the_author_meta('ID'));
?>

<div <?php post_class('single-blog-post'); ?>>
	<?php if(has_post_thumbnail()): ?>
		<img src="<?php the_post_thumbnail_url('full') ?>" alt="<?php the_title_attribute(); ?>">
		<div class="post-content with-img">
	<?php else: ?>
	<div class="post-content">
	<?php endif;?>
		<div class="post-meta">
			<span><i class="fa fa-user"></i><?php echo esc_html(get_the_author()); ?></span>
			<span><i class="fa fa-comments"></i><?php echo get_comments_number();?> <?php esc_html_e('نظرات', 'foodking'); ?></span>
			<span><i class="fa fa-calendar-alt"></i><?php echo esc_html(get_the_date('d M Y')); ?></span>
		</div>
		<h1><a href="<?php the_permalink();?>"><?php the_title();?></a></h1>
		<p><?php echo esc_html(get_the_excerpt());?></p>
		<div class="d-flex justify-content-between align-items-center mt-4">
			<div class="post-link">
				<a href="<?php the_permalink();?>"><?php echo esc_html($read_more); ?> <i class="fas fa-arrow-right"></i></a>
			</div>
		</div>
	</div>
</div>
