<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to foodking/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version    9.7.0
 */
global $foodking_opt;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' );
    $product_sidebar    = isset( $foodking_opt['product_sidebar']) ? $foodking_opt['product_sidebar'] : '';
    $title = get_the_title();

	// Blog breadcrumb
	// Single Product breadcrumb
	if( isset($foodking_opt['hide_product_banner']) ) {
		$hide_product_breadcrumb    	= $foodking_opt['hide_product_breadcrumb'];
		$hide_product_banner            = $foodking_opt['hide_product_banner'];
        $shop_banner_bg                 = $foodking_opt['shop_banner_bg']['url'];
	} else {
		$hide_product_breadcrumb   	= false;
		$hide_product_banner        = false; 
        $shop_banner_bg             = false;
	}
	

	// Blog page link
	if ( get_option( 'page_for_posts' ) ) {
		$product_link = get_permalink( get_option( 'page_for_posts' ));
	}else{
		$product_link = home_url( '/' );
	}

	$foodking_product_single_layout = !empty($foodking_opt['foodking_product_single_layout']) ? $foodking_opt['foodking_product_single_layout'] : 'container';

	if( isset($foodking_opt['page_title_tag']) ):
		$tag = $foodking_opt['page_title_tag'];
	else:
		$tag = 'h1';
	endif;

remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
?>

    <?php if( $hide_product_banner == false ): ?>
        <div class="breadcrumb-wrapper bg-cover" <?php if($shop_banner_bg): ?>style="background-image:url(<?php echo esc_url($shop_banner_bg); ?>);" <?php else: ?>style="background-image:url(<?php echo esc_url(get_template_directory_uri() .'/assets/img/breadcrumb.jpg') ?>);" <?php endif; ?>>
            <div class="container">
                <div class="page-heading center">
                    <?php if( isset($tag) ): ?>
                        <<?php echo esc_attr( $tag ); ?>><?php echo esc_html( $title ); ?></<?php echo esc_attr( $tag ); ?>>
                    <?php else: ?>
                        <<?php echo esc_attr( $tag ); ?>><?php esc_html_e('Blog Details', 'foodking'); ?></<?php echo esc_attr( $tag ); ?>>
                    <?php endif; ?>

                    <?php if( $hide_product_breadcrumb == false ): ?>
                        <?php
                            if ( function_exists('yoast_breadcrumb') ) {
                                yoast_breadcrumb( '<p class="foodking-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                            } else { ?>
                                <ul class="breadcrumb-items">
                                    <li class="d-inline-block position-relative"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Home', 'foodking' ); ?></a></li>
                                        <li class="d-inline-block position-relative"><a href="<?php echo esc_url( home_url( '/shop/' ) ); ?>"><?php esc_html_e('Shop', 'foodking'); ?></a></li>
                                        <li class="d-inline-block position-relative active"><?php the_title(); ?></li>
                                    <?php ?>                        
                                </ul>
                            <?php
                            }
                    endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div  class="products_details section-padding">
        <div class="container">
            <div class="row">
                <?php if ( is_active_sidebar( 'shop' ) ): ?>
                    <?php if ( isset( $_GET['shop'] ) ): ?>
                        <?php  $foodking_shop_cat_sidebar = $_GET['shop']; ?>
                        <?php if ( $foodking_shop_cat_sidebar == 'none' ): ?>
                            <div class="col-lg-12 col-md-12">
                        <?php elseif ( $foodking_shop_cat_sidebar == 'left' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $foodking_shop_cat_sidebar == 'right' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if( $product_sidebar == 'left-sidebar' ): ?>
                            <?php do_action( 'woocommerce_sidebar' ); ?>
                            <div class="col-lg-8 col-md-12">
                        <?php elseif ( $product_sidebar == 'right-sidebar' ): ?>
                            <div class="col-lg-8 col-md-12">
                        <?php else: ?>
                            <div class="col-lg-12 col-md-12">
                        <?php endif; ?>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="col-lg-12 col-md-12">
                <?php endif; ?>

                    <?php
                    /**
                     * woocommerce_before_main_content hook.
                     *
                     * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                     * @hooked woocommerce_breadcrumb - 20
                     */

                    do_action( 'woocommerce_before_main_content' );

                        while ( have_posts() ) : the_post();

                            wc_get_template_part( 'content', 'single-product' );

                        endwhile;

                        /**
                         * woocommerce_after_main_content hook.
                         *
                         * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                         */
                        do_action( 'woocommerce_after_main_content' );
                    ?>
                </div>
                <?php
                if ( isset( $_GET['shop'] ) ):
                    if ( $foodking_shop_cat_sidebar == 'right' ) :
                        do_action( 'woocommerce_sidebar' );
                    endif;
                else:
                    if ( $product_sidebar == 'right-sidebar' ):
                        do_action( 'woocommerce_sidebar' );
                    endif;
                endif;
                ?>
            </div>
        </div>
    </div>

    <?php get_footer( 'shop' );
    /* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
    ?>

